#
# Copyright The NOMAD Authors.
#
# This file is part of NOMAD.
# See https://nomad-lab.eu for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import numpy as np            # pylint: disable=unused-import
import typing                 # pylint: disable=unused-import
from nomad.metainfo import (  # pylint: disable=unused-import
    MSection, MCategory, Category, Package, Quantity, Section, SubSection, SectionProxy,
    Reference
)
from nomad.metainfo.legacy import LegacyDefinition

from siestaparser.metainfo import siesta_autogenerated
from nomad.datamodel.metainfo import public

m_package = Package(
    name='siesta_nomadmetainfo_json',
    description='None',
    a_legacy=LegacyDefinition(name='siesta.nomadmetainfo.json'))


class section_run(public.section_run):

    m_def = Section(validate=False, extends_base_section=True, a_legacy=LegacyDefinition(name='section_run'))

    x_siesta_system_label = Quantity(
        type=str,
        shape=[],
        description='''
        system label specified in siesta calculation.  This determines many of the
        filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_system_label'))

    x_siesta_system_name = Quantity(
        type=str,
        shape=[],
        description='''
        system name specified in siesta calculation.  This is purely a description.
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_system_name'))

    x_siesta_arch = Quantity(
        type=str,
        shape=[],
        description='''
        architecture
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_arch'))

    x_siesta_compilerflags = Quantity(
        type=str,
        shape=[],
        description='''
        basis set type
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_compilerflags'))


class x_siesta_section_input(siesta_autogenerated.x_siesta_section_input):

    m_def = Section(validate=False, extends_base_section=True, a_legacy=LegacyDefinition(name='x_siesta_section_input'))

    x_siesta_xc_authors = Quantity(
        type=str,
        shape=[],
        description='''
        XC authors (really: XC functional) in siesta calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_xc_authors'))

    x_siesta_typeofrun = Quantity(
        type=str,
        shape=[],
        description='''
        type of run as categorized by Siesta (optimization/md etc.)
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_typeofrun'))


class section_basis_set(public.section_basis_set):

    m_def = Section(validate=False, extends_base_section=True, a_legacy=LegacyDefinition(name='section_basis_set'))

    x_siesta_pao_basis_type = Quantity(
        type=str,
        shape=[],
        description='''
        basis set type
        ''',
        a_legacy=LegacyDefinition(name='x_siesta_pao_basis_type'))


m_package.__init_metainfo__()
