"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3AssemblyArtifactOptions = exports.GithubAssemblyArtifactOptions = exports.AssemblyArtifactOptions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const uuid_1 = require("uuid");
/**
 * Assembly artifact options applied to all jobs using artifacts in the workflow.
 */
class AssemblyArtifactOptions {
}
exports.AssemblyArtifactOptions = AssemblyArtifactOptions;
_a = JSII_RTTI_SYMBOL_1;
AssemblyArtifactOptions[_a] = { fqn: "@hojulian/cdk-pipelines-github.AssemblyArtifactOptions", version: "0.0.6" };
/**
 * Github assembly artifact options uses built-in `upload-artifact/download-artifact`
 * for artifacts handling.
 */
class GithubAssemblyArtifactOptions extends AssemblyArtifactOptions {
    constructor() {
        super();
    }
    downloadAssemblySteps(targetName, targetDir) {
        return [{
                name: `Download ${targetName}`,
                uses: 'actions/download-artifact@v3',
                with: {
                    name: targetName,
                    path: targetDir,
                },
            }];
    }
    ;
    uploadAssemblySteps(sourceName, sourceDir) {
        return [{
                name: `Upload ${sourceName}`,
                uses: 'actions/upload-artifact@v3',
                with: {
                    name: sourceName,
                    path: sourceDir,
                },
            }];
    }
    ;
}
exports.GithubAssemblyArtifactOptions = GithubAssemblyArtifactOptions;
_b = JSII_RTTI_SYMBOL_1;
GithubAssemblyArtifactOptions[_b] = { fqn: "@hojulian/cdk-pipelines-github.GithubAssemblyArtifactOptions", version: "0.0.6" };
/**
 * S3 assembly artifact options uses a given S3 bucket for artifacts handling.
 */
class S3AssemblyArtifactOptions extends AssemblyArtifactOptions {
    constructor(bucket) {
        super();
        this.bucket = bucket;
        this.seed = uuid_1.v4();
    }
    downloadAssemblySteps(targetName, targetDir) {
        return [{
                name: `Download ${targetName} from S3`,
                run: ['aws s3 sync', `s3://${this.bucket}/${this.seed}/${targetName}`, targetDir].join(' \\ \n'),
            }];
    }
    uploadAssemblySteps(sourceName, sourceDir) {
        return [{
                name: `Upload ${sourceName} to S3`,
                run: ['aws s3 sync', sourceDir, `s3://${this.bucket}/${this.seed}/${sourceName}`].join(' \\ \n'),
            }];
    }
}
exports.S3AssemblyArtifactOptions = S3AssemblyArtifactOptions;
_c = JSII_RTTI_SYMBOL_1;
S3AssemblyArtifactOptions[_c] = { fqn: "@hojulian/cdk-pipelines-github.S3AssemblyArtifactOptions", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,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