import * as github from './workflows-model';
/**
 * Assembly artifact options applied to all jobs using artifacts in the workflow.
 */
export declare abstract class AssemblyArtifactOptions {
    /**
     * Configure download assembly steps.
     *
     * @default - By default, it uses `actions/download-artifact@v3`.
     */
    abstract downloadAssemblySteps(targetName: string, targetDir: string): github.JobStep[];
    /**
     * Configure upload assembly steps.
     *
     * @default - By default, it uses `actions/upload-artifact@v3`.
     */
    abstract uploadAssemblySteps(sourceName: string, sourceDir: string): github.JobStep[];
}
/**
 * Github assembly artifact options uses built-in `upload-artifact/download-artifact`
 * for artifacts handling.
 */
export declare class GithubAssemblyArtifactOptions extends AssemblyArtifactOptions {
    constructor();
    downloadAssemblySteps(targetName: string, targetDir: string): github.JobStep[];
    uploadAssemblySteps(sourceName: string, sourceDir: string): github.JobStep[];
}
/**
 * S3 assembly artifact options uses a given S3 bucket for artifacts handling.
 */
export declare class S3AssemblyArtifactOptions extends AssemblyArtifactOptions {
    private readonly bucket;
    private readonly seed;
    constructor(bucket: string);
    downloadAssemblySteps(targetName: string, targetDir: string): github.JobStep[];
    uploadAssemblySteps(sourceName: string, sourceDir: string): github.JobStep[];
}
