import pyeccodes.accessors as _


def load(h):

    h.add(_.Constant('gridDefinitionTemplateNumber', 20))
    h.add(_.Signed('Ni', 2))
    h.alias('numberOfPointsAlongAParallel', 'Ni')
    h.alias('Nx', 'Ni')
    h.alias('geography.Ni', 'Ni')
    h.add(_.Signed('Nj', 2))
    h.alias('numberOfPointsAlongAMeridian', 'Nj')
    h.alias('Nx', 'Nj')
    h.alias('geography.Nj', 'Nj')
    h.add(_.Signed('latitudeOfFirstGridPoint', 3))
    h.add(_.Scale('latitudeOfFirstGridPointInDegrees', _.Get('latitudeOfFirstGridPoint'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.latitudeOfFirstGridPointInDegrees', 'latitudeOfFirstGridPointInDegrees')
    h.alias('La1', 'latitudeOfFirstGridPoint')
    h.add(_.Signed('longitudeOfFirstGridPoint', 3))
    h.add(_.Scale('longitudeOfFirstGridPointInDegrees', _.Get('longitudeOfFirstGridPoint'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.longitudeOfFirstGridPointInDegrees', 'longitudeOfFirstGridPointInDegrees')
    h.alias('Lo1', 'longitudeOfFirstGridPoint')
    h.add(_.Codeflag('resolutionAndComponentFlags', 1, "grib1/7.table"))
    h.add(_.Bit('ijDirectionIncrementGiven', _.Get('resolutionAndComponentFlags'), 7))
    h.alias('iDirectionIncrementGiven', 'ijDirectionIncrementGiven')
    h.alias('jDirectionIncrementGiven', 'ijDirectionIncrementGiven')
    h.alias('DiGiven', 'ijDirectionIncrementGiven')
    h.alias('DjGiven', 'ijDirectionIncrementGiven')
    h.add(_.Bit('earthIsOblate', _.Get('resolutionAndComponentFlags'), 6))

    if h.get_l('earthIsOblate'):
        h.add(_.Transient('earthMajorAxis', 6.37816e+06))
        h.add(_.Transient('earthMinorAxis', 6.35678e+06))
        h.alias('earthMajorAxisInMetres', 'earthMajorAxis')
        h.alias('earthMinorAxisInMetres', 'earthMinorAxis')

    h.add(_.Bit('resolutionAndComponentFlags3', _.Get('resolutionAndComponentFlags'), 5))
    h.add(_.Bit('resolutionAndComponentFlags4', _.Get('resolutionAndComponentFlags'), 4))
    h.add(_.Bit('uvRelativeToGrid', _.Get('resolutionAndComponentFlags'), 3))
    h.add(_.Bit('resolutionAndComponentFlags6', _.Get('resolutionAndComponentFlags'), 2))
    h.add(_.Bit('resolutionAndComponentFlags7', _.Get('resolutionAndComponentFlags'), 1))
    h.add(_.Bit('resolutionAndComponentFlags8', _.Get('resolutionAndComponentFlags'), 0))
    h.add(_.Signed('latitudeOfLastGridPoint', 3))
    h.add(_.Scale('latitudeOfLastGridPointInDegrees', _.Get('latitudeOfLastGridPoint'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.latitudeOfLastGridPointInDegrees', 'latitudeOfLastGridPointInDegrees')
    h.alias('La2', 'latitudeOfLastGridPoint')
    h.add(_.Signed('longitudeOfLastGridPoint', 3))
    h.add(_.Scale('longitudeOfLastGridPointInDegrees', _.Get('longitudeOfLastGridPoint'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.longitudeOfLastGridPointInDegrees', 'longitudeOfLastGridPointInDegrees')
    h.alias('Lo2', 'longitudeOfLastGridPoint')
    h.alias('yFirst', 'latitudeOfFirstGridPointInDegrees')
    h.alias('yLast', 'latitudeOfLastGridPointInDegrees')
    h.alias('xFirst', 'longitudeOfFirstGridPointInDegrees')
    h.alias('xLast', 'longitudeOfLastGridPointInDegrees')
    h.alias('latitudeFirstInDegrees', 'latitudeOfFirstGridPointInDegrees')
    h.alias('longitudeFirstInDegrees', 'longitudeOfFirstGridPointInDegrees')
    h.alias('latitudeLastInDegrees', 'latitudeOfLastGridPointInDegrees')
    h.alias('longitudeLastInDegrees', 'longitudeOfLastGridPointInDegrees')
    h.add(_.Signed('Latin', 3))
    h.add(_.Scale('LaDInDegrees', _.Get('Latin'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.LaDInDegrees', 'LaDInDegrees')
    h.add(_.Pad('padding_grid1_1', 1))
    h.alias('yFirst', 'latitudeOfFirstGridPointInDegrees')
    h.alias('yLast', 'latitudeOfLastGridPointInDegrees')
    h.alias('xFirst', 'longitudeOfFirstGridPointInDegrees')
    h.alias('xLast', 'longitudeOfLastGridPointInDegrees')
    h.add(_.Codeflag('scanningMode', 1, "grib1/8.table"))
    h.add(_.Bit('iScansNegatively', _.Get('scanningMode'), 7))
    h.add(_.Bit('jScansPositively', _.Get('scanningMode'), 6))
    h.add(_.Bit('jPointsAreConsecutive', _.Get('scanningMode'), 5))
    h.add(_.Constant('alternativeRowScanning', 0))
    h.add(_.Transient('iScansPositively', not (_.Get('iScansNegatively'))))
    h.alias('geography.iScansNegatively', 'iScansNegatively')
    h.alias('geography.jScansPositively', 'jScansPositively')
    h.alias('geography.jPointsAreConsecutive', 'jPointsAreConsecutive')
    h.add(_.Bit('scanningMode4', _.Get('scanningMode'), 4))
    h.add(_.Bit('scanningMode5', _.Get('scanningMode'), 3))
    h.add(_.Bit('scanningMode6', _.Get('scanningMode'), 2))
    h.add(_.Bit('scanningMode7', _.Get('scanningMode'), 1))
    h.add(_.Bit('scanningMode8', _.Get('scanningMode'), 0))
    h.add(_.Change_scanning_direction('swapScanningX', _.Get('values'), _.Get('Ni'), _.Get('Nj'), _.Get('iScansNegatively'), _.Get('jScansPositively'), _.Get('xFirst'), _.Get('xLast'), _.Get('x')))
    h.alias('swapScanningLon', 'swapScanningX')
    h.add(_.Change_scanning_direction('swapScanningY', _.Get('values'), _.Get('Ni'), _.Get('Nj'), _.Get('iScansNegatively'), _.Get('jScansPositively'), _.Get('yFirst'), _.Get('yLast'), _.Get('y')))
    h.alias('swapScanningLat', 'swapScanningY')

    if h.get_l('jPointsAreConsecutive'):
        h.alias('numberOfRows', 'Ni')
        h.alias('numberOfColumns', 'Nj')
    else:
        h.alias('numberOfRows', 'Nj')
        h.alias('numberOfColumns', 'Ni')

    h.add(_.Signed('DiInMetres', 3))
    h.alias('longitudinalDirectionGridLength', 'DiInMetres')
    h.alias('Di', 'DiInMetres')
    h.alias('geography.DiInMetres', 'DiInMetres')
    h.add(_.Signed('DjInMetres', 3))
    h.alias('latitudinalDirectionGridLength', 'DjInMetres')
    h.alias('Dj', 'DjInMetres')
    h.alias('geography.DjInMetres', 'DjInMetres')
    h.add(_.Constant('orientationOfTheGridInDegrees', 0))
    h.add(_.Pad('padding_grid1_2', 8))
    h.add(_.Number_of_points('numberOfDataPoints', _.Get('Ni'), _.Get('Nj')))
    h.alias('numberOfPoints', 'numberOfDataPoints')
    h.add(_.Number_of_values('numberOfValues', _.Get('values'), _.Get('bitsPerValue'), _.Get('numberOfDataPoints'), _.Get('bitmapPresent'), _.Get('bitmap'), _.Get('numberOfCodedValues')))
