/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import oracle.pg.rdbms.pgql.pgview.translation.expression.PathProjection;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryVariable;

public class RecursiveWith
extends PathProjection {
    private final boolean isAcyclic;
    private final boolean isTrail;

    public RecursiveWith(QueryVariable alias, String srcTranslation, String dstTranslation, String patternTranslation, int kValue, long minHops, long maxHops, boolean isAcyclic, boolean isTrail, boolean addRownum) {
        super(alias, srcTranslation, dstTranslation, patternTranslation, kValue, minHops, maxHops, addRownum);
        this.isAcyclic = isAcyclic;
        this.isTrail = isTrail;
    }

    @Override
    public String prettyPrint() {
        return "(WITH t1(src_table, src_key,\n          dst_table, dst_key,\n" + (this.isTrail ? "edge_table, edge_key,\n" : "") + "          exp, lvl)\nAS (\n  -- Anchor member.\n  SELECT \"src_table\" AS src_table, \"src_key\" AS src_key,          \"src_table\" AS dst_table, \"src_key\" AS dst_key, " + (this.isTrail ? "'' AS edge_table, null as edge_key, " : "") + "         '' AS exp, 0 AS lvl   FROM(" + this.srcTranslation + ")\n  UNION ALL\n  -- Recursive member.\n  SELECT t1.src_table, t1.src_key,\n         t2.\"dst_table\" AS dst_table, t2.\"dst_key\" AS dst_key,\n" + (this.isTrail ? " t2.\"edge_table\" AS edge_table, t2.\"edge_key\" AS edge_key,\n" : "") + "         t1.exp || t2.\"exp\" AS exp,\n         t1.lvl + 1 AS lvl \n    FROM (" + this.patternTranslation + ") t2, t1\n   WHERE t2.\"src_table\" = t1.dst_table\n     AND t2.\"src_key\" = t1.dst_key\n" + (this.maxHops != -1L ? "     AND t1.lvl < " + this.maxHops + "\n" : "") + ") " + (this.isAcyclic ? "cycle dst_table, dst_key set is_cycle to 'Y' default 'N'" : "") + (this.isTrail ? "cycle edge_table, edge_key set is_cycle to 'Y' default 'N'" : "") + "\nSELECT src_table, src_key,\n       dst_table, dst_key,\n       '<EXP_PATH>' || exp || '</EXP_PATH>' AS EXP_PATH" + (this.addRownum ? ",\n       ROWNUM AS \"ROWN_$\"" : "") + "\nFROM t1 \n" + (this.minHops != 0L ? "WHERE lvl >= " + this.minHops + "\n" : "") + (this.isAcyclic || this.isTrail ? (this.minHops != 0L ? "AND " : "WHERE ") + "is_cycle = 'N'\n" : "") + ")" + PgqlUtils.printIdentifier((String)this.alias.getName());
    }
}

