/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.shell.aargparse.impl.converter;

import java.io.File;
import oracle.pgx.shell.aargparse.Argument;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.ArgumentParser;
import oracle.pgx.shell.aargparse.exceptions.ArgumentParserException;

public class FileConverter
implements ArgumentConverter<File> {
    private boolean verifyIsFile;
    private boolean verifyCanRead;
    private boolean verifyCanWrite;

    public FileConverter verifyIsFile() {
        this.verifyIsFile = true;
        return this;
    }

    public FileConverter verifyCanRead() {
        this.verifyCanRead = true;
        return this;
    }

    public FileConverter verifyCanWrite() {
        this.verifyCanWrite = true;
        return this;
    }

    @Override
    public File convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        File file = new File(value);
        if (this.verifyIsFile && !file.isFile()) {
            throw new ArgumentParserException(parser, arg, value, "provided value " + value + " is not a file");
        }
        if (this.verifyCanRead && !file.canRead()) {
            throw new ArgumentParserException(parser, arg, value, "provided value " + value + " cannot be read");
        }
        if (this.verifyCanWrite && !file.canWrite()) {
            throw new ArgumentParserException(parser, arg, value, "provided value " + value + " cannot be written");
        }
        return file;
    }
}

