/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.io.TermReader;

public interface TextTermReader
extends TermReader {
    @Override
    default public IStrategoTerm readFromBytes(byte[] bytes) {
        return this.readFromBytes(bytes, StandardCharsets.UTF_8);
    }

    default public IStrategoTerm readFromBytes(byte[] bytes, Charset characterSet) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                return this.read(inputStream, characterSet);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage(), e);
        }
    }

    default public IStrategoTerm readFromString(String str) {
        StringReader reader = new StringReader(str);
        try {
            return this.read(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage(), e);
        }
    }

    @Override
    default public IStrategoTerm readFromFile(File file) throws IOException, SecurityException {
        return this.readFromFile(file, StandardCharsets.UTF_8);
    }

    /*
     * Loose catch block
     */
    default public IStrategoTerm readFromFile(File file, Charset characterSet) throws IOException, SecurityException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream fileStream = new FileInputStream(file);){
            IStrategoTerm iStrategoTerm;
            BufferedInputStream inputStream;
            Throwable throwable2;
            block19: {
                throwable2 = null;
                Object var7_10 = null;
                inputStream = new BufferedInputStream(fileStream);
                iStrategoTerm = this.read(inputStream, characterSet);
                if (inputStream == null) break block19;
                inputStream.close();
            }
            return iStrategoTerm;
            {
                catch (Throwable throwable3) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @Override
    default public IStrategoTerm readFromPath(Path path) throws IOException, SecurityException {
        return this.readFromPath(path, StandardCharsets.UTF_8);
    }

    default public IStrategoTerm readFromPath(Path path, Charset characterSet) throws IOException, SecurityException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = Files.newBufferedReader(path, characterSet);){
            return this.read(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public IStrategoTerm read(InputStream inputStream) throws IOException {
        return this.read(inputStream, StandardCharsets.UTF_8);
    }

    default public IStrategoTerm read(InputStream inputStream, Charset characterSet) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, characterSet);
        return this.read(reader);
    }

    public IStrategoTerm read(Reader var1) throws IOException;
}

