/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import java.util.ArrayList;
import java.util.Stack;
import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.util.DebugUtil;

public abstract class Strategy
implements IConstruct {
    private static final SDefT.ArgType type;
    private transient String traceName;
    private Stack<Hook> hook = new Stack();

    static {
        ArrayList<SDefT.ArgType> l = new ArrayList<SDefT.ArgType>(2);
        l.add(SDefT.ConstType.INSTANCE);
        type = new SDefT.FunType(l);
    }

    @Deprecated
    public static void debug(Object ... s) {
        if (!DebugUtil.isDebugging()) {
            return;
        }
        Context.debug(s);
    }

    public SDefT.ArgType getType() {
        return type;
    }

    protected String getTraceName() {
        if (this.traceName == null) {
            this.traceName = this.getClass().getSimpleName();
        }
        return this.traceName;
    }

    public String toString() {
        return this.getTraceName();
    }

    public Stack<Hook> getHook() {
        return this.hook;
    }

    public boolean evaluate(IContext env) throws InterpreterException {
        ResultHook resultHook = new ResultHook();
        this.getHook().push(resultHook);
        Stack<Strategy> debugStack = null;
        boolean debug = DebugUtil.isDebugging();
        if (debug) {
            debugStack = new Stack<Strategy>();
        }
        IConstruct c = this;
        while (c != null) {
            if (debug) {
                debugStack.push((Strategy)c);
            }
            c = c.eval(env);
        }
        if (debug) {
            for (Strategy strat : debugStack) {
                if (strat.getHook().size() == 0) continue;
                throw new InterpreterException("There was a leak on: " + debugStack);
            }
        }
        return resultHook.result;
    }

    static class ResultHook
    extends Hook {
        boolean result;

        ResultHook() {
        }

        @Override
        public IConstruct onFailure(IContext env) throws InterpreterException {
            this.result = false;
            return null;
        }

        @Override
        public IConstruct onSuccess(IContext env) throws InterpreterException {
            this.result = true;
            return null;
        }
    }
}

