/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mb.resource.hierarchical.match.path.string.PathStringMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AnyPathStringMatcher
implements PathStringMatcher {
    private final List<PathStringMatcher> matchers;

    public AnyPathStringMatcher(ArrayList<PathStringMatcher> matchers) {
        this.matchers = matchers;
    }

    public AnyPathStringMatcher(PathStringMatcher ... matchers) {
        this.matchers = Arrays.asList(matchers);
    }

    @Override
    public boolean matches(String pathString) {
        for (PathStringMatcher matcher : this.matchers) {
            if (!matcher.matches(pathString)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnyPathStringMatcher other = (AnyPathStringMatcher)obj;
        return this.matchers.equals(other.matchers);
    }

    public int hashCode() {
        return Objects.hash(this.matchers);
    }

    public String toString() {
        return "AnyPathStringMatcher(" + this.matchers.toString() + ")";
    }
}

