/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.impl.AQueryAnswer;
import mb.scopegraph.oopsla20.reference.Env;

public final class QueryAnswer<S, L, D>
extends AQueryAnswer<S, L, D>
implements Serializable {
    private final Env<S, L, D> env;
    private final ImmutableSet<IRecordedQuery<S, L, D>> transitiveQueries;
    private final ImmutableSet<IRecordedQuery<S, L, D>> predicateQueries;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private QueryAnswer(Env<S, L, D> env, Iterable<? extends IRecordedQuery<S, L, D>> transitiveQueries, Iterable<? extends IRecordedQuery<S, L, D>> predicateQueries) {
        this.env = Objects.requireNonNull(env, "env");
        this.transitiveQueries = ImmutableSet.copyOf(transitiveQueries);
        this.predicateQueries = ImmutableSet.copyOf(predicateQueries);
    }

    private QueryAnswer(QueryAnswer<S, L, D> original, Env<S, L, D> env, ImmutableSet<IRecordedQuery<S, L, D>> transitiveQueries, ImmutableSet<IRecordedQuery<S, L, D>> predicateQueries) {
        this.env = env;
        this.transitiveQueries = transitiveQueries;
        this.predicateQueries = predicateQueries;
    }

    @Override
    public Env<S, L, D> env() {
        return this.env;
    }

    @Override
    public ImmutableSet<IRecordedQuery<S, L, D>> transitiveQueries() {
        return this.transitiveQueries;
    }

    @Override
    public ImmutableSet<IRecordedQuery<S, L, D>> predicateQueries() {
        return this.predicateQueries;
    }

    public final QueryAnswer<S, L, D> withEnv(Env<S, L, D> value) {
        if (this.env == value) {
            return this;
        }
        Env<S, L, D> newValue = Objects.requireNonNull(value, "env");
        return new QueryAnswer<S, L, D>(this, newValue, this.transitiveQueries, this.predicateQueries);
    }

    @SafeVarargs
    public final QueryAnswer<S, L, D> withTransitiveQueries(IRecordedQuery<S, L, D> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new QueryAnswer<S, L, D>(this, this.env, newValue, this.predicateQueries);
    }

    public final QueryAnswer<S, L, D> withTransitiveQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
        if (this.transitiveQueries == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new QueryAnswer<S, L, D>(this, this.env, newValue, this.predicateQueries);
    }

    @SafeVarargs
    public final QueryAnswer<S, L, D> withPredicateQueries(IRecordedQuery<S, L, D> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new QueryAnswer<S, L, D>(this, this.env, this.transitiveQueries, newValue);
    }

    public final QueryAnswer<S, L, D> withPredicateQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
        if (this.predicateQueries == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new QueryAnswer<S, L, D>(this, this.env, this.transitiveQueries, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof QueryAnswer && this.equalTo((QueryAnswer)another);
    }

    private boolean equalTo(QueryAnswer<?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.env.equals(another.env) && this.transitiveQueries.equals(another.transitiveQueries) && this.predicateQueries.equals(another.predicateQueries);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.env.hashCode();
        h += (h << 5) + this.transitiveQueries.hashCode();
        h += (h << 5) + this.predicateQueries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueryAnswer").omitNullValues().add("env", this.env).add("transitiveQueries", this.transitiveQueries).add("predicateQueries", this.predicateQueries).toString();
    }

    public static <S, L, D> QueryAnswer<S, L, D> of(Env<S, L, D> env, Set<IRecordedQuery<S, L, D>> transitiveQueries, Set<IRecordedQuery<S, L, D>> predicateQueries) {
        return QueryAnswer.of(env, transitiveQueries, predicateQueries);
    }

    public static <S, L, D> QueryAnswer<S, L, D> of(Env<S, L, D> env, Iterable<? extends IRecordedQuery<S, L, D>> transitiveQueries, Iterable<? extends IRecordedQuery<S, L, D>> predicateQueries) {
        return new QueryAnswer<S, L, D>(env, transitiveQueries, predicateQueries);
    }

    public static <S, L, D> QueryAnswer<S, L, D> copyOf(AQueryAnswer<S, L, D> instance) {
        if (instance instanceof QueryAnswer) {
            return (QueryAnswer)instance;
        }
        return QueryAnswer.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ QueryAnswer(QueryAnswer queryAnswer, Env env, ImmutableSet immutableSet, ImmutableSet immutableSet2, QueryAnswer queryAnswer2) {
        this(queryAnswer, env, immutableSet, immutableSet2);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ENV = 1L;
        private long initBits = 1L;
        private Env<S, L, D> env;
        private ImmutableSet.Builder<IRecordedQuery<S, L, D>> transitiveQueries = ImmutableSet.builder();
        private ImmutableSet.Builder<IRecordedQuery<S, L, D>> predicateQueries = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder<S, L, D> from(AQueryAnswer<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.env(instance.env());
            this.addAllTransitiveQueries(instance.transitiveQueries());
            this.addAllPredicateQueries(instance.predicateQueries());
            return this;
        }

        public final Builder<S, L, D> env(Env<S, L, D> env) {
            this.env = Objects.requireNonNull(env, "env");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> addTransitiveQueries(IRecordedQuery<S, L, D> element) {
            this.transitiveQueries.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addTransitiveQueries(IRecordedQuery<S, L, D> ... elements) {
            this.transitiveQueries.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> transitiveQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.transitiveQueries = ImmutableSet.builder();
            return this.addAllTransitiveQueries(elements);
        }

        public final Builder<S, L, D> addAllTransitiveQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.transitiveQueries.addAll(elements);
            return this;
        }

        public final Builder<S, L, D> addPredicateQueries(IRecordedQuery<S, L, D> element) {
            this.predicateQueries.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addPredicateQueries(IRecordedQuery<S, L, D> ... elements) {
            this.predicateQueries.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> predicateQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.predicateQueries = ImmutableSet.builder();
            return this.addAllPredicateQueries(elements);
        }

        public final Builder<S, L, D> addAllPredicateQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.predicateQueries.addAll(elements);
            return this;
        }

        public QueryAnswer<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new QueryAnswer(null, this.env, this.transitiveQueries.build(), this.predicateQueries.build(), null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("env");
            }
            return "Cannot build QueryAnswer, some of required attributes are not set " + attributes;
        }
    }
}

