/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.CollectionProxyResponse;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemoteCollectionProxyFactory;

public class CollectionProxyMarshaler
implements Marshaler<CollectionProxy> {
    private final SessionContext sessionContext;
    private final RemoteCollectionProxyFactory collectionProxyFactory;

    public CollectionProxyMarshaler(SessionContext sessionContext, RemoteCollectionProxyFactory factory) {
        this.sessionContext = sessionContext;
        this.collectionProxyFactory = factory;
    }

    public CollectionProxyMarshaler() {
        this(null, null);
    }

    @Override
    public CollectionProxy unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.collectionProxyFactory == null) {
            throw new IllegalStateException("collection proxy factory is not set");
        }
        if (this.sessionContext.getSessionId() == null) {
            throw new IllegalStateException("session is not set");
        }
        CollectionProxyResponse response = (CollectionProxyResponse)((Object)JsonUtil.readTopLevelJson((String)jsonString, CollectionProxyResponse.class));
        CollectionProxy ret = this.collectionProxyFactory.createRemoteCollectionProxy(this.sessionContext, response.proxyId, response.collectionType, response.size, response.valueType, response.wrappedEntities);
        return ret;
    }

    @Override
    public String marshal(CollectionProxy proxy) throws JsonGenerationException, JsonMappingException, IOException {
        String proxyUUID = proxy.getId();
        boolean isWrapped = proxy.containsWrappedElement();
        PropertyType valueType = proxy.getElementType();
        CollectionType collectionType = proxy.getType();
        CollectionProxyResponse response = new CollectionProxyResponse(proxyUUID);
        response.proxyId = proxyUUID;
        response.size = proxy.size();
        response.valueType = valueType;
        response.collectionType = collectionType;
        response.wrappedEntities = isWrapped;
        return JsonUtil.toJson((Object)((Object)response));
    }
}

