/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.PgqlResultSetImpl;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.api.internal.PreparedStatementProxy;
import oracle.pgx.common.BindValue;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.pojo.BindValueImpl;
import oracle.pgx.common.types.internal.ValueType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphConfig;

public class PgxPreparedStatementImpl
implements PgxPreparedStatement {
    private final Core core;
    private final PgxSession session;
    private final PgxGraph graph;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final PreparedStatementProxy proxy;
    private BindValue[] bindValues;
    private PgxFuture<PgqlResultSet> lastResult;

    public PgxPreparedStatementImpl(Core core, PgxGraph graph, PreparedStatementProxy proxy, PgxSession session, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.core = core;
        this.session = session;
        this.graph = graph;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.keystorePathSupplier = keystorePathSupplier;
        this.proxy = proxy;
        this.bindValues = new BindValueImpl[proxy.getBindVariableCount()];
    }

    @Override
    public PgxFuture<PgqlResultSet> executeQueryAsync() {
        if (this.proxy.getStatementType() != StatementType.SELECT) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"PREPARED_STATEMENT_IS_NOT_A_SELECT_QUERY", (Object[])new Object[0]));
        }
        for (int i = 0; i < this.proxy.getBindVariableCount(); ++i) {
            if (this.bindValues[i] != null) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ILLEGAL_BIND_VALUE_NULL", (Object[])new Object[]{i + 1}));
        }
        return this.core.executePreparedStatement(this.session.getSessionContext(), this.graph.getId(), this.proxy.getId(), this.bindValues).thenApply(resultSet -> new PgqlResultSetImpl(this.core, this.graph, this.keystorePathSupplier, this.keystorePasswordSupplier, (PgqlResultSetProxy)resultSet));
    }

    @Override
    public PgqlResultSet executeQuery() throws PgqlException {
        try {
            return this.executeQueryAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PgqlException((Throwable)e);
        }
    }

    @Override
    public boolean execute() throws PgqlException {
        try {
            return this.executeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PgqlException((Throwable)e);
        }
    }

    @Override
    public PgxFuture<Boolean> executeAsync() {
        PgxFuture<Boolean> promise = new PgxFuture<Boolean>();
        for (int i = 0; i < this.proxy.getBindVariableCount(); ++i) {
            if (this.bindValues[i] != null) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ILLEGAL_BIND_VALUE_NULL", (Object[])new Object[]{i + 1}));
        }
        switch (this.proxy.getStatementType()) {
            case SELECT: {
                this.lastResult = this.core.executeAnyPreparedStatement(this.session.getSessionContext(), this.graph.getId(), this.proxy.getId(), this.bindValues).cancelOn(promise).handle((resultSet, exception) -> {
                    if (exception != null) {
                        promise.completeExceptionally((Throwable)exception);
                    }
                    PgqlResultSetImpl result = new PgqlResultSetImpl(this.core, this.graph, this.keystorePathSupplier, this.keystorePasswordSupplier, (PgqlResultSetProxy)resultSet);
                    promise.complete(true);
                    return result;
                });
                break;
            }
            case GRAPH_MODIFY: {
                PgxId graphId = this.graph == null ? null : this.graph.getId();
                ((PgxFuture)this.core.executeAnyPreparedStatement(this.session.getSessionContext(), graphId, this.proxy.getId(), this.bindValues).cancelOn(promise).exceptionally(e -> {
                    promise.completeExceptionally((Throwable)new PgqlException(e));
                    return null;
                })).thenApply(future -> promise.complete(false));
                break;
            }
            case CREATE_PROPERTY_GRAPH: {
                GraphConfig graphConfig = this.proxy.getCreatePropertyGraphConfig();
                this.session.readGraphWithPropertiesAsync(graphConfig).cancelOn(promise).thenApply(future -> promise.complete(false));
                break;
            }
            default: {
                throw new IllegalArgumentException(this.proxy.getStatementType().name());
            }
        }
        return promise;
    }

    @Override
    public PgqlResultSet getResultSet() throws PgqlException {
        try {
            return this.getResultSetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PgqlException((Throwable)e);
        }
    }

    @Override
    public PgxFuture<PgqlResultSet> getResultSetAsync() throws PgqlException {
        if (this.lastResult == null) {
            throw new PgqlException(ErrorMessages.getMessage((String)"PREPARED_STATEMENT_NO_RESULT", (Object[])new Object[0]));
        }
        PgxFuture<PgqlResultSet> tmp = this.lastResult;
        this.lastResult = null;
        return tmp;
    }

    public void setBoolean(int parameterIndex, boolean x) throws PgqlException {
        this.set(parameterIndex, ValueType.BOOLEAN, x);
    }

    public void setDouble(int parameterIndex, double x) throws PgqlException {
        this.set(parameterIndex, ValueType.DOUBLE, x);
    }

    public void setFloat(int parameterIndex, float x) throws PgqlException {
        this.set(parameterIndex, ValueType.FLOAT, Float.valueOf(x));
    }

    public void setInt(int parameterIndex, int x) throws PgqlException {
        this.set(parameterIndex, ValueType.INTEGER, x);
    }

    public void setLong(int parameterIndex, long x) throws PgqlException {
        this.set(parameterIndex, ValueType.LONG, x);
    }

    public void setString(int parameterIndex, String x) throws PgqlException {
        this.set(parameterIndex, ValueType.STRING, x);
    }

    public void setDate(int parameterIndex, LocalDate x) throws PgqlException {
        this.set(parameterIndex, ValueType.LOCAL_DATE, x);
    }

    public void setTime(int parameterIndex, LocalTime x) throws PgqlException {
        this.set(parameterIndex, ValueType.TIME, x);
    }

    public void setTimestamp(int parameterIndex, LocalDateTime x) throws PgqlException {
        this.set(parameterIndex, ValueType.TIMESTAMP, x);
    }

    public void setTimeWithTimezone(int parameterIndex, OffsetTime x) throws PgqlException {
        this.set(parameterIndex, ValueType.TIME_WITH_TIMEZONE, x);
    }

    public void setTimestampWithTimezone(int parameterIndex, OffsetDateTime x) throws PgqlException {
        this.set(parameterIndex, ValueType.TIMESTAMP_WITH_TIMEZONE, x);
    }

    public void setPoint2D(int parameterIndex, Point2D x) throws PgqlException {
        this.set(parameterIndex, ValueType.POINT2D, x);
    }

    public void setArray(int parameterIndex, List<?> x) throws PgqlException {
        this.set(parameterIndex, ValueType.ARRAY, x);
    }

    public void close() throws PgqlException {
        this.core.destroyPreparedStatement(this.session.getSessionContext(), this.proxy.getId()).join();
    }

    private void set(int parameterIndex, ValueType type, Object x) throws PgqlException {
        if (x == null) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"CANNOT_SET_BIND_VARIABLE_TO_NULL", (Object[])new Object[0]));
        }
        this.checkIndex(parameterIndex);
        this.bindValues[parameterIndex - 1] = new BindValueImpl(type, x);
    }

    private void checkIndex(int parameterIndex) throws PgqlException {
        if (parameterIndex < 0) {
            throw new PgqlException(ErrorMessages.getMessage((String)"ILLEGAL_BIND_VARIABLE_INDEX_NEGATIVE", (Object[])new Object[]{parameterIndex}));
        }
        if (parameterIndex == 0) {
            throw new PgqlException(ErrorMessages.getMessage((String)"ILLEGAL_BIND_VARIABLE_INDEX_ZERO", (Object[])new Object[0]));
        }
        if (parameterIndex > this.proxy.getBindVariableCount()) {
            throw new PgqlException(ErrorMessages.getMessage((String)"ILLEGAL_BIND_VARIABLE_INDEX_POSITIVE", (Object[])new Object[]{parameterIndex, this.proxy.getBindVariableCount()}));
        }
    }
}

