/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.admin.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.admin.internal.InternalControl;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.util.FileUtils;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractControl
implements InternalControl {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractControl.class);
    public static final String LOG_MESSAGE_NO_CONFIG_FOUND = "no server config file specified, will use defaults";
    private static final UserContext USER_CONTEXT = UserContext.UNAUTHENTICATED_USER_CONTEXT;
    private final VirtualFileManager vfm;

    public AbstractControl() {
        StaticConfig.get().isEnablePluginVersionChecks();
        this.vfm = VirtualFileManagerFactory.getInstance();
    }

    public static <T> PgxFuture<T> runOnCallerThread(Callable<T> task) {
        try {
            return PgxFuture.completedFuture(task.call());
        }
        catch (Throwable th) {
            return PgxFuture.exceptionallyCompletedFuture(th);
        }
    }

    @Override
    public final PgxFuture<Void> start(boolean runPostStart, InternalControl.DeferredPreloadedGraphLoadedCallback callback) {
        return AbstractControl.runOnCallerThread(() -> PgxConfig.getFilePath()).thenCompose(path -> {
            Throwable throwable;
            InputStream is;
            if (path == null) {
                LOG.warn(LOG_MESSAGE_NO_CONFIG_FOUND);
                return this.start(Collections.emptyMap(), runPostStart, callback);
            }
            LOG.info("Loading PGX config from {}", path);
            try {
                is = this.vfm.getInputStream(path, false, USER_CONTEXT);
                throwable = null;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Starting PGX config {}", (Object)FileUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("couldn't close InputStream", e);
            }
            try {
                is = this.vfm.getInputStream(path, false, USER_CONTEXT);
                throwable = null;
                try {
                    PgxFuture<Void> pgxFuture = this.start(is, runPostStart, callback);
                    return pgxFuture;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("couldn't close InputStream", e);
            }
        });
    }

    @Override
    public final PgxFuture<Void> start(Map<PgxConfig.Field, Object> config, boolean runPostStart, InternalControl.DeferredPreloadedGraphLoadedCallback callback) {
        return AbstractControl.runOnCallerThread(() -> JsonUtil.toJson((Object)config)).thenCompose(json -> this.start((String)json, runPostStart, callback));
    }

    @Override
    public final PgxFuture<Void> start(InputStream config, boolean runPostStart, InternalControl.DeferredPreloadedGraphLoadedCallback callback) {
        return AbstractControl.runOnCallerThread(() -> FileUtils.toString((InputStream)config, (Charset)StandardCharsets.UTF_8)).thenCompose(json -> this.start((String)json, runPostStart, callback));
    }

    @Override
    public final PgxFuture<Void> start(String json, boolean runPostStart, InternalControl.DeferredPreloadedGraphLoadedCallback callback) {
        String keystorePath = System.getProperty("pgx.keystore_path");
        System.clearProperty("pgx.keystore_path");
        String keystorePassword = System.getProperty("pgx.keystore_password");
        System.clearProperty("pgx.keystore_password");
        char[] passwordArray = keystorePassword == null ? null : keystorePassword.toCharArray();
        return this.start(json, keystorePath, passwordArray, runPostStart, callback);
    }

    @Override
    public PgxFuture<Void> shutdownNowIfRunning() {
        return this.isRunning().thenCompose(isRunning -> {
            if (isRunning.booleanValue()) {
                return this.shutdownNow();
            }
            return PgxFuture.completedFuture(null);
        });
    }

    @Override
    public PgxFuture<Void> updatePgxConfig(Map<PgxConfig.Field, Object> config) {
        return AbstractControl.runOnCallerThread(() -> JsonUtil.toJson((Object)config)).thenCompose(this::updatePgxConfig);
    }

    @Override
    public PgxFuture<Void> updatePgxConfig(InputStream config) {
        return AbstractControl.runOnCallerThread(() -> FileUtils.toString((InputStream)config, (Charset)StandardCharsets.UTF_8)).thenCompose(this::updatePgxConfig);
    }
}

