/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.concurrent.ExecutionException;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.ScalarValue;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;

public class Scalar<V>
extends PgxManagedObject {
    private final Core core;
    private final PgxSession session;
    private final PgxGraph graph;
    private final String scalarName;
    private final PropertyType type;
    private final int dimension;

    private V wrap(Comparable val) {
        if (val == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_SCALAR_VALUE", (Object[])new Object[0]));
        }
        switch (this.getType()) {
            case VERTEX: {
                return (V)new PgxVertex<Comparable>(this.graph, val);
            }
            case EDGE: {
                return (V)new PgxEdge(this.graph, (Long)val);
            }
        }
        return (V)val;
    }

    private static Class<?> expectedTypeClass(PropertyType type) {
        switch (type) {
            case VERTEX: {
                return PgxVertex.class;
            }
            case EDGE: {
                return PgxEdge.class;
            }
        }
        return type.getTypeClass();
    }

    private void typeCheck(V val) {
        if (val == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_SCALAR_VALUE", (Object[])new Object[0]));
        }
        Class expect = this.dimension > 0 ? PgxVect.class : Scalar.expectedTypeClass(this.getType());
        if (val.getClass() != expect) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ILLEGAL_SCALAR_VALUE_TYPE", (Object[])new Object[]{this.getName(), expect.getSimpleName(), val.getClass().getSimpleName()}));
        }
    }

    private Object unwrapVal(V val) {
        if (val == null || !this.type.isNodeOrEdge()) {
            return val;
        }
        return ((PgxEntity)val).getId();
    }

    Scalar(PgxGraph graph, String scalarName, PropertyType type) {
        this.graph = graph;
        this.scalarName = scalarName;
        this.type = type;
        this.core = this.graph.getSession().getCore();
        this.session = this.graph.getSession();
        this.dimension = 0;
    }

    Scalar(PgxGraph graph, String scalarName, PropertyType type, int dimension) {
        this.graph = graph;
        this.scalarName = scalarName;
        this.type = type;
        this.core = this.graph.getSession().getCore();
        this.session = this.graph.getSession();
        this.dimension = dimension;
    }

    @Override
    public String getName() {
        return this.scalarName;
    }

    public PgxGraph getGraph() {
        return this.graph;
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyScalar(this.session.getSessionContext(), this.scalarName);
    }

    public PropertyType getType() {
        return this.type;
    }

    public int getDimension() {
        return this.dimension;
    }

    public PgxFuture<V> getAsync() {
        return ((PgxFuture)this.core.getScalarValue(this.session.getSessionContext(), this.scalarName).thenApply(ScalarValue::getValue)).thenApply(this::wrap);
    }

    public PgxFuture<Void> setAsync(V value) {
        try {
            this.typeCheck(value);
            Object obj = this.unwrapVal(value);
            return this.core.setScalarValue(this.session.getSessionContext(), this.scalarName, obj);
        }
        catch (Throwable e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
    }

    public String toString() {
        return this.toString(Scalar.entry("name", this.getName()), Scalar.entry("type", this.getType().toKey()), Scalar.entry("graph", this.getGraph().getName()));
    }

    public V get() throws ExecutionException, InterruptedException {
        return this.getAsync().get();
    }

    public void set(V value) throws ExecutionException, InterruptedException {
        this.setAsync(value).get();
    }
}

