/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.internal.categorymapping.CategoryMappingConfig;
import oracle.pgx.config.mllib.GraphWiseBaseConvLayerConfig;
import oracle.pgx.config.mllib.GraphWiseBaseModelConfig;
import oracle.pgx.config.mllib.inputconfig.InputPropertyConfig;

public abstract class GraphWiseModelConfig
extends GraphWiseBaseModelConfig {
    public static final GraphConvModelVariant DEFAULT_MODE = null;
    private GraphConvModelVariant variant = DEFAULT_MODE;
    private List<Set<String>> targetVertexLabelSets;

    GraphWiseModelConfig() {
    }

    public GraphWiseModelConfig(int batchSize, int numEpochs, double learningRate, double weightDecay, int embeddingDim, Integer seed, GraphWiseBaseConvLayerConfig[] convLayerConfigs, boolean standardize, boolean normalize, boolean shuffle, List<String> vertexInputPropertyNames, List<String> edgeInputPropertyNames, Map<String, InputPropertyConfig> vertexInputPropertyConfigs, Map<String, InputPropertyConfig> edgeInputPropertyConfigs, CategoryMappingConfig categoryMappingConfig, boolean fitted, double trainingLoss, int vertexInputFeatureDim, int edgeInputFeatureDim, List<Set<String>> targetVertexLabelSets, GraphWiseBaseModelConfig.Backend backend, GraphConvModelVariant variant, boolean enableAccelerator) {
        super(batchSize, numEpochs, learningRate, weightDecay, embeddingDim, seed, convLayerConfigs, standardize, normalize, shuffle, vertexInputPropertyNames, edgeInputPropertyNames, vertexInputPropertyConfigs, edgeInputPropertyConfigs, categoryMappingConfig, fitted, trainingLoss, vertexInputFeatureDim, edgeInputFeatureDim, backend, enableAccelerator);
        this.targetVertexLabelSets = targetVertexLabelSets;
        this.variant = variant;
    }

    GraphWiseModelConfig(GraphWiseModelConfig source) {
        super(source);
        this.setTargetVertexLabelSets(source.getTargetVertexLabelSets());
        this.variant = source.getVariant();
    }

    public GraphWiseModelConfig(GraphWiseModelConfig source, CategoryMappingConfig categoryMappingConfig) {
        this(source);
        this.categoryMappingConfig = categoryMappingConfig;
    }

    public List<Set<String>> getTargetVertexLabelSets() {
        return this.targetVertexLabelSets;
    }

    public final void setTargetVertexLabelSets(List<Set<String>> targetVertexLabelSets) {
        this.targetVertexLabelSets = targetVertexLabelSets;
    }

    public void setTargetVertexLabels(List<String> targetVertexLabels) {
        this.targetVertexLabelSets = GraphWiseModelConfig.listOfStringsToListOfSetOfStrings(targetVertexLabels);
    }

    public final void setVariant(GraphConvModelVariant variant) {
        if (this.variant != null) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"IMMUTABLE_GRAPHWISE_VARIANT", (Object[])new Object[0]));
        }
        this.variant = variant;
    }

    public GraphConvModelVariant getVariant() {
        return this.variant;
    }

    private static List<Set<String>> listOfStringsToListOfSetOfStrings(List<String> targetVertexLabels) {
        return targetVertexLabels.stream().map(label -> new HashSet<String>(Collections.singletonList(label))).collect(Collectors.toList());
    }

    public static enum GraphConvModelVariant {
        GRAPHWISE,
        INTERTWINED;

    }
}

