/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.types.QueryArgumentType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.PreparedQueryArgumentConfig;

public final class PreparedQueryArgumentConfigBuilder {
    private final Map<PreparedQueryArgumentConfig.Field, Object> values = new HashMap<PreparedQueryArgumentConfig.Field, Object>();

    public static PreparedQueryArgumentConfig buildPreparedQueryArgumentConfig(Consumer<PreparedQueryArgumentConfigBuilder> builderSetup) {
        PreparedQueryArgumentConfigBuilder builder = new PreparedQueryArgumentConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PreparedQueryArgumentConfigBuilder() {
    }

    public PreparedQueryArgumentConfigBuilder(Map<PreparedQueryArgumentConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PreparedQueryArgumentConfigBuilder(PreparedQueryArgumentConfig config) {
        this.putAll(config);
    }

    public PreparedQueryArgumentConfigBuilder(PreparedQueryArgumentConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PreparedQueryArgumentConfigBuilder putAll(Map<PreparedQueryArgumentConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PreparedQueryArgumentConfigBuilder putAll(PreparedQueryArgumentConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PreparedQueryArgumentConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PreparedQueryArgumentConfig build(String parentPath) {
        try {
            return PreparedQueryArgumentConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PreparedQueryArgumentConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PreparedQueryArgumentConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PreparedQueryArgumentConfigBuilder" + this.values;
    }

    public PreparedQueryArgumentConfigBuilder setType(QueryArgumentType type) {
        this.values.put(PreparedQueryArgumentConfig.Field.TYPE, type);
        return this;
    }

    public PreparedQueryArgumentConfigBuilder setValue(Object value) {
        this.values.put(PreparedQueryArgumentConfig.Field.VALUE, value);
        return this;
    }
}

