/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractAuthorizationEntityConfig;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractEngineConfig;
import oracle.pgx.config.AuthorizationEntityConfig;
import oracle.pgx.config.AuthorizationLocationConfig;
import oracle.pgx.config.BasicSchedulerConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.PreloadGraphConfig;
import oracle.pgx.config.RuntimeConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPgxConfig
extends AbstractEngineConfig {
    public static final String FILE_PATH_PROPERTY = "pgx_conf";
    public static final String DEFAULT_FILE_NAME = "pgx.conf";
    private static final Logger LOG = LoggerFactory.getLogger(PgxConfig.class);
    private static final VirtualFileManager VFM = VirtualFileManagerFactory.getInstance();
    protected boolean isSmConfig;
    protected boolean isClusterLeader;
    protected RuntimeConfig runtimeConfig;

    public static String getFilePath() throws IOException {
        String path = System.getProperty(FILE_PATH_PROPERTY);
        if (path != null) {
            return path;
        }
        path = "res:/pgx.conf";
        if (VFM.resolve(path, UserContext.SYSTEM_USER_CONTEXT).exists()) {
            return path;
        }
        path = DEFAULT_FILE_NAME;
        if (VFM.resolve(path, UserContext.SYSTEM_USER_CONTEXT).exists()) {
            return path;
        }
        return null;
    }

    public static PgxConfig getInstance() {
        try {
            return AbstractPgxConfig.getInstance(ConfigJsonUtil.toJsonInputStream(Collections.emptyMap()), null);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PgxConfig getInstance(String path) {
        if (path == null) return AbstractPgxConfig.getInstance();
        try (InputStream is = VFM.getInputStream(path, false, UserContext.SYSTEM_USER_CONTEXT);){
            PgxConfig pgxConfig = AbstractPgxConfig.getInstance(is, null);
            return pgxConfig;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static PgxConfig getInstance(InputStream is, String parent) throws IOException {
        if (is == null) {
            throw new NullPointerException();
        }
        return AbstractPgxConfig.initPgxConfig(is, parent);
    }

    private static boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static PgxConfig initPgxConfig(InputStream is, String parent) throws IOException {
        Map<String, Object> rawConfigValues = ConfigParser.parseRaw(is);
        AbstractPgxConfig.overwriteWithSystemProperties(rawConfigValues, parent);
        String hostnamesKey = PgxConfig.Field.EXISTING_HOSTNAMES.toKey();
        Object hostnames = rawConfigValues.get(hostnamesKey);
        if (hostnames == null) {
            hostnamesKey = PgxConfig.Field.HOSTNAMES.toKey();
            hostnames = rawConfigValues.get(hostnamesKey);
        }
        boolean isSmConfig = hostnames == null;
        boolean isClusterLeader = false;
        if (!isSmConfig) {
            List<String> listHostnames;
            if (hostnames.getClass() == String.class) {
                listHostnames = AbstractPgxConfig.parseHostnameList((String)hostnames);
            } else if (hostnames instanceof List) {
                List<String> hostnameList = (List<String>)hostnames;
                listHostnames = hostnameList.size() == 1 ? AbstractPgxConfig.parseHostnameList((String)hostnameList.get(0)) : hostnameList;
            } else {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"COULD_NOT_PARSE_HOSTNAME_LIST", (Object[])new Object[0]));
            }
            rawConfigValues.put(hostnamesKey, listHostnames);
            try {
                InetAddress leaderAddr = InetAddress.getByName((String)listHostnames.get(0));
                isClusterLeader = AbstractPgxConfig.isLocalAddress(leaderAddr);
            }
            catch (UnknownHostException e) {
                LOG.warn("Could not resolve leader hostname: " + listHostnames.get(0), (Throwable)e);
                throw e;
            }
        }
        AbstractPgxConfig.extractLegacyFjPoolConfig(rawConfigValues);
        boolean strict = AbstractPgxConfig.isStrict(rawConfigValues, isSmConfig);
        PgxConfig pgxConfig = PgxConfig.parse(rawConfigValues, strict, parent);
        pgxConfig.runtimeConfig = pgxConfig.extractRuntimeConfig();
        pgxConfig.isSmConfig = isSmConfig;
        pgxConfig.isClusterLeader = isClusterLeader;
        return pgxConfig;
    }

    private static List<String> parseHostnameList(String hostnamesStr) throws IOException {
        hostnamesStr = "[" + Arrays.stream(hostnamesStr.replace('[', ' ').replace(']', ' ').trim().split(",")).map(host -> "\"" + host.trim() + "\"").collect(Collectors.joining(",")) + "]";
        return Arrays.asList((Object[])ConfigJsonUtil.readValue(hostnamesStr, String[].class));
    }

    private static void extractLegacyFjPoolConfig(Map<String, Object> raw) {
        String basicConfigKey = PgxConfig.Field.BASIC_SCHEDULER_CONFIG.toKey();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        boolean containsNewConfig = raw.containsKey(basicConfigKey);
        if (containsNewConfig) {
            valueMap.putAll((Map)raw.get(basicConfigKey));
        }
        for (BasicSchedulerConfig.Field field : BasicSchedulerConfig.Field.values()) {
            String fieldKey = field.toKey();
            Object value = raw.remove(fieldKey);
            if (value == null) continue;
            if (containsNewConfig) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DEPRECATED_CONFIG_USED_TOGETHER_WITH_UPDATED_CONFIG", (Object[])new Object[]{fieldKey, basicConfigKey + "." + fieldKey}));
            }
            valueMap.put(fieldKey, value);
        }
        if (valueMap.size() != 0) {
            raw.put(basicConfigKey, valueMap);
        }
    }

    private static boolean isStrict(Map<String, Object> raw, boolean isSmConfig) {
        boolean isReleaseMode = StaticConfig.get().isRelease();
        if (!isSmConfig && !isReleaseMode) {
            return false;
        }
        Object rawStrict = raw.get(PgxConfig.Field.STRICT_MODE.toKey());
        boolean strict = rawStrict == null || rawStrict.getClass() != Boolean.class ? ((Boolean)PgxConfig.Field.STRICT_MODE.getDefaultVal()).booleanValue() : ((Boolean)rawStrict).booleanValue();
        return strict;
    }

    private static void overwriteWithSystemProperties(Map<String, Object> raw, String parent) {
        AbstractPgxConfig.readConfigFromEnvironment((String)parent, null, (ConfigField[])PgxConfig.Field.values()).forEach((key, value) -> AbstractPgxConfig.insertOverride(raw, key, value));
    }

    private static void insertOverride(Map<String, Object> raw, String key, Object value) {
        if (raw.containsKey(key) && value instanceof AbstractConfig) {
            AbstractConfig abstractConfig = (AbstractConfig)value;
            Map<? extends ConfigField, Object> newValues = abstractConfig.getValues();
            Object existingValue = raw.get(key);
            assert (existingValue instanceof Map);
            Map originalMap = (Map)existingValue;
            LOG.trace("merging configuration {} into {}", newValues, (Object)originalMap);
            newValues.forEach((configField, o) -> AbstractPgxConfig.mergeConfigValue(originalMap, configField, o));
            LOG.trace("result: {}", (Object)originalMap);
            return;
        }
        raw.put(key, value);
    }

    private static void mergeConfigValue(Map originalConfigMap, ConfigField configField, Object newValue) {
        if (configField.getType() == Map.class && originalConfigMap.containsKey(configField.toKey())) {
            assert (newValue instanceof Map);
            Map mapWithOverrideValues = (Map)newValue;
            Object originalValue = originalConfigMap.get(configField.toKey());
            assert (originalValue instanceof Map);
            Map originalMap = (Map)originalValue;
            LOG.trace("[config field '{}'] merging {} and {}", new Object[]{configField, originalMap, mapWithOverrideValues});
            originalMap.putAll(mapWithOverrideValues);
            LOG.trace("[config field '{}'] result: {}", (Object)configField, (Object)originalMap);
        } else {
            originalConfigMap.put(configField.toKey(), newValue);
        }
    }

    public static PgxConfig configFromJson(String json) throws IOException {
        try (InputStream is = IOUtils.toInputStream((String)json, (Charset)Charset.defaultCharset());){
            PgxConfig pgxConfig = PgxConfig.getInstance(is, null);
            return pgxConfig;
        }
    }

    public static PgxConfig configFromMap(Map<PgxConfig.Field, Object> configValues) throws IOException {
        return AbstractPgxConfig.configFromJson(ConfigJsonUtil.toJson(configValues));
    }

    public synchronized RuntimeConfig getRuntimeConfig() {
        if (this.runtimeConfig == null) {
            this.runtimeConfig = this.extractRuntimeConfig();
        }
        return this.runtimeConfig;
    }

    RuntimeConfig extractRuntimeConfig() {
        Map<PgxConfig.Field, Object> pgxConfigValues = this.getValues();
        HashMap<RuntimeConfig.Field, Object> runtimeConfigValues = new HashMap<RuntimeConfig.Field, Object>();
        for (RuntimeConfig.Field field : RuntimeConfig.Field.values()) {
            PgxConfig.Field pgxConfigField = PgxConfig.Field.valueOf(field.name());
            runtimeConfigValues.put(field, pgxConfigValues.get(pgxConfigField));
        }
        return RuntimeConfig.getInstance(runtimeConfigValues);
    }

    public abstract Map<PgxConfig.Field, Object> getValues();

    public abstract String getUdfConfigDirectory();

    public abstract List<PreloadGraphConfig> getPreloadGraphs();

    public abstract List<AuthorizationLocationConfig> getFileLocations();

    @Override
    public abstract List<AuthorizationEntityConfig> getAuthorization();

    public Map<String, AbstractAuthorizationEntityConfig.Permissions> getUserPermissionMapping() {
        return this.getPermissionMapping(AbstractAuthorizationEntityConfig::getPgxUser);
    }

    public Map<String, AbstractAuthorizationEntityConfig.Permissions> getRolePermissionMapping() {
        return this.getPermissionMapping(AbstractAuthorizationEntityConfig::getPgxRole);
    }

    private Map<String, AbstractAuthorizationEntityConfig.Permissions> getPermissionMapping(Function<AuthorizationEntityConfig, String> entityGetter) {
        HashMap<String, AbstractAuthorizationEntityConfig.Permissions> permissions = new HashMap<String, AbstractAuthorizationEntityConfig.Permissions>();
        this.getAuthorization().stream().filter(item -> entityGetter.apply((AuthorizationEntityConfig)item) != null).forEach(item -> {
            String entity = (String)entityGetter.apply((AuthorizationEntityConfig)item);
            if (permissions.containsKey(entity)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_DUPLICATE_PERMISSION_ENTRY", (Object[])new Object[]{entity}));
            }
            permissions.put(entity, item.getAllPermissions());
        });
        return permissions;
    }

    @Override
    public void validate() {
        super.validate();
        this.validateAuthorizationConfig();
    }

    public boolean isDistConfig() {
        return !this.isSmConfig;
    }

    public boolean isSmConfig() {
        return this.isSmConfig;
    }

    public boolean isClusterLeader() {
        return this.isSmConfig || !this.isSmConfig && this.isClusterLeader;
    }

    private void validateAuthorizationConfig() {
        this.validateGraphAuthorizations();
        this.validateStorageAuthorizations();
    }

    private void validateGraphAuthorizations() {
        Set<String> preloadedGraphs = this.getPreloadGraphs().stream().map(PreloadGraphConfig::getName).collect(Collectors.toSet());
        if (LOG.isDebugEnabled()) {
            LOG.debug("preloaded graphs:");
            preloadedGraphs.forEach(graph -> LOG.debug("\t{}", graph));
        }
        this.validateGraphAuthorizations(preloadedGraphs, this.getUserPermissionMapping().values());
        this.validateGraphAuthorizations(preloadedGraphs, this.getRolePermissionMapping().values());
    }

    private void validateGraphAuthorizations(Set<String> preloadedGraphs, Collection<AbstractAuthorizationEntityConfig.Permissions> resourcePermissions) {
        resourcePermissions.stream().map(AbstractAuthorizationEntityConfig.Permissions::getGraphPermissions).flatMap(permissionMapping -> permissionMapping.keySet().stream()).filter(graphName -> !preloadedGraphs.contains(graphName)).forEach(graphName -> {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_UNKNOWN_PRELOADED_GRAPH", (Object[])new Object[]{graphName}));
        });
    }

    private void validateStorageAuthorizations() {
        Set<String> storages = this.getFileLocations().stream().map(AuthorizationLocationConfig::getName).collect(Collectors.toSet());
        this.validateStorageAuthorizations(storages, this.getUserPermissionMapping().values());
        this.validateStorageAuthorizations(storages, this.getRolePermissionMapping().values());
    }

    private void validateStorageAuthorizations(Set<String> storages, Collection<AbstractAuthorizationEntityConfig.Permissions> resourcePermissions) {
        resourcePermissions.stream().map(AbstractAuthorizationEntityConfig.Permissions::getStoragePermissions).flatMap(permissionMapping -> permissionMapping.keySet().stream()).filter(fileLocation -> !storages.contains(fileLocation)).forEach(fileLocation -> {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_UNKNOWN_FILE_LOCATION", (Object[])new Object[]{fileLocation}));
        });
    }
}

