/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import oracle.graphviz.pgql.AbstractPgqlDriver;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.ServerInstanceHelper;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.auth.AuthorizationException;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.driver.KerberosAuthentication;
import oracle.pgx.graphviz.driver.PgxGraphInformation;
import oracle.pgx.graphviz.driver.PgxServerInstanceProvider;
import oracle.pgx.graphviz.driver.PgxSessionWrapper;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.Enhancer;
import oracle.pgx.realm.client.RealmClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class PgxDriver
extends AbstractPgqlDriver
implements PgxServerInstanceProvider {
    public static final String DEFAULT_SESSION_SOURCE = "oracle.pgx.graphviz.pgxdriver";
    public static final String ACCESS_TOKEN_PROPERTY = "graphviz.driver.access-token";
    public static final String REALM_CLIENT_CLASS_NAME = "graphviz.driver.realm-client-class-name";
    public static final String AUTH_TOKEN_ATTRIBUTE = "auth-token";
    public static final String USERNAME_ATTRIBUTE = "username";
    public static final String DRIVER_SESSION_ATTRIBUTE = "driver-session-id";
    public static final String ALLOW_EXTERNAL_CONNECTIONS = "allow_external_connections";

    public PgxDriver(Map<String, Object> properties) {
        super(properties);
    }

    @Override
    public ServerInstance connect(Map<String, Object> properties) {
        String realmClientClassName;
        Boolean allowExternalConnection;
        Properties localProperties = new Properties();
        localProperties.putAll(properties);
        ClientConfig clientConfig = ClientConfig.parse((Properties)localProperties, (boolean)true);
        String accessToken = (String)localProperties.get(ACCESS_TOKEN_PROPERTY);
        String allowExternalConnectionSrt = (String)localProperties.get(ALLOW_EXTERNAL_CONNECTIONS);
        if (allowExternalConnectionSrt != null && !(allowExternalConnection = Boolean.valueOf(allowExternalConnectionSrt)).booleanValue()) {
            LOG.debug("allow external connection = {}", (Object)allowExternalConnection);
            clientConfig.getValues().put(ClientConfig.Field.BASE_URL, Pgx.EMBEDDED_URL);
        }
        if (accessToken != null) {
            LOG.debug("setting access token");
            clientConfig.getValues().put(ClientConfig.Field.ACCESS_TOKEN, accessToken);
        }
        if ((realmClientClassName = (String)properties.get(REALM_CLIENT_CLASS_NAME)) != null) {
            try {
                LOG.info("loading realm client {}", (Object)realmClientClassName);
                Class<?> realmClientClass = Class.forName(realmClientClassName);
                RealmClient realmClient = (RealmClient)realmClientClass.getDeclaredConstructor(Map.class).newInstance(localProperties);
                realmClient.setToken(accessToken);
                return ServerInstanceHelper.getInstance(clientConfig, realmClient);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("could not instantiate realm client", e);
            }
        }
        return ServerInstanceHelper.getInstance(clientConfig);
    }

    protected PgxSessionWrapper getOrCreateSession(Map<String, Object> properties) {
        try {
            boolean keepOpen;
            PgxSession session;
            String sessionId = null;
            if (properties != null) {
                sessionId = (String)properties.get("graphviz.driver.session");
            }
            ServerInstance instance = this.connect(properties);
            if (sessionId != null) {
                session = instance.getSession(sessionId);
                if (session == null) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SESSION_NOT_FOUND", (Object[])new Object[]{sessionId}));
                }
                keepOpen = true;
            } else {
                session = instance.createSession(DEFAULT_SESSION_SOURCE);
                keepOpen = false;
            }
            String parallelism = (String)properties.get("parallelism");
            if (parallelism != null) {
                int threadsPerTask = Integer.parseInt(parallelism);
                session.getExecutionEnvironment().getAnalysisEnvironment().setMaxNumThreads(Integer.valueOf(threadsPerTask));
            }
            return new PgxSessionWrapper(session, keepOpen);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private PgxGraph getGraphFromPgqlGraphRef(PgxSession session, String pgqlGraphRef) throws ExecutionException, InterruptedException {
        Namespace[] namespaceOrder = new Namespace[]{Namespace.PRIVATE, Namespace.PUBLIC};
        boolean matchCaseInsensitive = pgqlGraphRef.equals(pgqlGraphRef.toUpperCase());
        try {
            for (Namespace namespace : namespaceOrder) {
                List graphNamesInNamespace = session.getGraphs(namespace);
                if (graphNamesInNamespace.contains(pgqlGraphRef)) {
                    return session.getGraph(namespace, pgqlGraphRef);
                }
                if (!matchCaseInsensitive) continue;
                for (String graphName : graphNamesInNamespace) {
                    if (!graphName.toUpperCase().equals(pgqlGraphRef)) continue;
                    return session.getGraph(namespace, graphName);
                }
            }
            return null;
        }
        catch (ExecutionException e) {
            Exception cause;
            if (Objects.nonNull(e) && Objects.nonNull(e.getCause()) && (cause = (Exception)e.getCause()).getClass() == AuthorizationException.class) {
                return null;
            }
            throw e;
        }
    }

    public Response login(HttpServletRequest request, Map<String, Object> staticProperties, String username, String password, String sessionId) throws IOException, LoginException {
        String content;
        int statusCode;
        Cookie stickyCookie = null;
        String token = null;
        boolean isKerberosAuthEnabled = Boolean.parseBoolean((String)staticProperties.get("graphviz.driver.auth.kerberos"));
        String json = null;
        if (isKerberosAuthEnabled) {
            LOG.debug("kerberos authentication");
            String ticket = KerberosAuthentication.getKerberosTicket(staticProperties, null, (String)username, (String)password);
            if (ticket == null) {
                LOG.info("kerberos ticket could not be generated, username and password is incorrect.");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Kerberos ticket could not be generated, username and password is incorrect.").build();
            }
            json = "{ \"kerberosTicket\": \"" + ticket + "\" }";
        } else {
            LOG.debug("normal authentication");
            json = "{ \"username\": \"" + username + "\", \"password\": \"" + password + "\" }";
        }
        String baseUrl = (String)staticProperties.get("base_url");
        if (baseUrl == null || baseUrl.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Graph Server base URL is not specified or is incorrect").build();
        }
        BasicCookieStore httpCookieStore = new BasicCookieStore();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)httpCookieStore);
        CloseableHttpClient httpClient = builder.build();
        HttpPost postRequest = new HttpPost(baseUrl + "/auth/token");
        StringEntity params = new StringEntity(json);
        postRequest.addHeader("Content-Type", (Object)"application/json");
        postRequest.setEntity((HttpEntity)params);
        try {
            ClassicHttpResponse response = (ClassicHttpResponse)httpClient.execute((ClassicHttpRequest)postRequest);
            statusCode = response.getCode();
            LOG.debug("got status code {} from PGX", (Object)statusCode);
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException | ParseException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Failed to login: " + ex.getCause().getMessage())).build();
        }
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(content, Map.class);
        if (statusCode != 201) {
            return Response.status((int)statusCode).entity(map.get("error_message")).build();
        }
        token = (String)map.get("access_token");
        stickyCookie = httpCookieStore.getCookies().stream().filter(p -> p.getName().equals("PGX_INSTANCE_STICKY_COOKIE")).findFirst().orElse(null);
        boolean isPgxSessionProvidedExternally = false;
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.putAll(staticProperties);
            if (token != null) {
                props.put(ACCESS_TOKEN_PROPERTY, token);
            }
            if (stickyCookie != null) {
                props.put("PGX_INSTANCE_STICKY_COOKIE", stickyCookie);
            }
            if (StringUtils.isNotEmpty((CharSequence)sessionId)) {
                props.put("graphviz.driver.session", sessionId);
                isPgxSessionProvidedExternally = true;
            }
            sessionId = this.createSession(PgxDriver.class.getName(), props);
        }
        catch (Exception e) {
            LOG.error("failed to create session ID", (Throwable)e);
            if (isPgxSessionProvidedExternally) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Failed retrieving session ID: " + e.getMessage())).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Failed to create session ID").build();
        }
        HttpSession session = request.getSession();
        session.setAttribute(USERNAME_ATTRIBUTE, (Object)username);
        session.setAttribute(DRIVER_SESSION_ATTRIBUTE, (Object)sessionId);
        session.setAttribute(ACCESS_TOKEN_PROPERTY, (Object)token);
        session.setAttribute("PGX_INSTANCE_STICKY_COOKIE", (Object)stickyCookie);
        session.setAttribute("provided-externally", (Object)isPgxSessionProvidedExternally);
        LOG.info("{} logged in - new HTTP session: {}", (Object)username, (Object)session.isNew());
        String queryParams = request.getQueryString();
        String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/" + request.getContextPath();
        if (queryParams != null) {
            url = url + "?" + queryParams;
        }
        return Response.seeOther((URI)URI.create(url)).build();
    }

    public String createSession(String source, Map<String, Object> properties) {
        try {
            ServerInstance instance = this.connect(properties);
            String sessionId = (String)properties.get("graphviz.driver.session");
            if (sessionId != null) {
                return instance.getSession(sessionId).getId();
            }
            return instance.createSession(source).getId();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void destroySession(String id, Map<String, Object> properties) {
        try {
            ServerInstance instance = this.connect(properties);
            PgxSession session = instance.getSession(id);
            if (session != null) {
                session.destroy();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public EnhancedResultSet query(@Nonnull String pgqlQuery, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException {
        PgxSessionWrapper session = this.getOrCreateSession(properties);
        try {
            Enhancer enhancer = (Enhancer)properties.get("enhancer");
            Pair canViz = enhancer.checkIfVisualizable();
            List header = enhancer.getOriginalHeader();
            properties.put("original_header", header);
            if (((Boolean)canViz.getFirst()).booleanValue()) {
                Enhancement enhancement = enhancer.enhance();
                pgqlQuery = "/*ALLOW_REFERENCING_ANY_PROPERTY*/ " + enhancement.getQuery();
                properties.put("enhancement", enhancement);
            }
            PgqlResultSet rs = session.getSession().queryPgql((String)pgqlQuery);
            EnhancedResultSet enhancedResultSet = super.getEnhancedResultSet((ResultSet)rs, schema, graphName, ((Boolean)canViz.getFirst()).booleanValue(), this.isDirectedSupported(), this.supportsMultipleIterations(), properties);
            if (session != null) {
                session.close();
            }
            return enhancedResultSet;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PgqlException((Throwable)e);
            }
        }
    }

    @Nonnull
    public String modify(@Nonnull String pgqlQuery, @Nonnull String graphName, Map<String, Object> properties) throws PgqlException {
        PgxSessionWrapper session = this.getOrCreateSession(properties);
        try {
            session.getSession().executePgql(pgqlQuery);
            String string = "";
            if (session != null) {
                session.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PgqlException((Throwable)e);
            }
        }
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) {
        PgxSessionWrapper sessionWrapper = this.getOrCreateSession(properties);
        try {
            PgxSession session = sessionWrapper.getSession();
            HashSet graphNames = new HashSet();
            for (Namespace ns : Arrays.asList(Namespace.PUBLIC, Namespace.PRIVATE)) {
                graphNames.addAll(session.getGraphs(ns).stream().map(g -> new GraphName(g)).collect(Collectors.toSet()));
            }
            HashSet hashSet = graphNames;
            if (sessionWrapper != null) {
                sessionWrapper.close();
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                if (sessionWrapper != null) {
                    try {
                        sessionWrapper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String name, Map<String, Object> properties) {
        PgxSessionWrapper session = this.getOrCreateSession(properties);
        try {
            PgxGraph graph = this.getGraphFromPgqlGraphRef(session.getSession(), name);
            if (graph == null) {
                throw new NoSuchElementException(String.format("The graph named %s does not exist or is not accessible for session: %s", name, session.toString()));
            }
            PgxGraphInformation pgxGraphInformation = new PgxGraphInformation(graph);
            if (session != null) {
                session.close();
            }
            return pgxGraphInformation;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getVersion(Map<String, Object> properties) throws SQLException {
        return VersionInfo.getInstance((String)"sm").getReleaseVersion();
    }

    public void close() throws Exception {
    }
}

