/*
 * Decompiled with CFR 0.152.
 */
package oracle.datastudio.graphviz.gvt.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMultiset;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.datastudio.graphviz.ResultGraphCreator;
import oracle.datastudio.graphviz.gvt.json.Edge;
import oracle.datastudio.graphviz.gvt.json.Vertex;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Graph;
import oracle.pgx.graphviz.formatter.Property;

public class ResultGraph
implements ResultGraphCreator {
    @JsonProperty(value="vertices")
    public List<Vertex> vertices;
    @JsonProperty(value="edges")
    public List<Edge> edges;
    @JsonProperty(value="numResults")
    public long numResults;

    public ResultGraph() {
    }

    private ResultGraph(@Nonnull List<Vertex> vertices, @Nonnull List<Edge> edges, long numResults) {
        this.vertices = vertices;
        this.edges = edges;
        this.numResults = numResults;
    }

    @Nullable
    public ResultGraph fromEnhancedResultSet(@Nonnull EnhancedResultSet enhancedResultSet, int start, int size) {
        return ResultGraph.staticfromEnhancedResultSet(enhancedResultSet, start, size);
    }

    @Nullable
    public static ResultGraph staticfromEnhancedResultSet(@Nonnull EnhancedResultSet enhancedResultSet, int start, int size) {
        Graph graph = enhancedResultSet.createGraphRepresentation(start, size);
        if (graph != null) {
            List<Vertex> vertices = graph.getVertices().stream().map(ResultGraph::mapVertex).collect(Collectors.toList());
            List<Edge> edges = graph.getEdges().stream().map(ResultGraph::mapEdge).collect(Collectors.toList());
            return new ResultGraph(vertices, edges, enhancedResultSet.getNumResults());
        }
        return null;
    }

    @Nonnull
    private static Edge mapEdge(@Nonnull oracle.pgx.graphviz.formatter.Edge edge) {
        Edge ret = new Edge(edge.getId(), edge.getSourceId(), edge.getDestId(), ResultGraph.mapProperty(edge.getProperties()));
        return ret;
    }

    @Nonnull
    private static Vertex mapVertex(@Nonnull oracle.pgx.graphviz.formatter.Vertex vertex) {
        Vertex ret = new Vertex(vertex.getId(), ResultGraph.mapProperty(vertex.getProperties()));
        return ret;
    }

    @Nonnull
    private static ObjectNode mapProperty(@Nonnull Collection<Property> propertylist) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        for (Property property : propertylist) {
            rootNode.put(property.getName(), property.getValue());
        }
        return rootNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultGraph that = (ResultGraph)o;
        return ImmutableMultiset.copyOf(this.vertices).equals((Object)ImmutableMultiset.copyOf(that.vertices)) && ImmutableMultiset.copyOf(this.edges).equals((Object)ImmutableMultiset.copyOf(that.edges)) && this.numResults == that.numResults;
    }

    public int hashCode() {
        return Objects.hash(ImmutableMultiset.copyOf(this.vertices), ImmutableMultiset.copyOf(this.edges), this.numResults);
    }
}

