/*
 * Decompiled with CFR 0.152.
 */
package oracle.datastudio.graphviz.formatter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.datastudio.graphviz.ResultGraphCreator;
import oracle.datastudio.graphviz.formatter.json.ResultGraph;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Formatter;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.formatter.ResultType;
import oracle.pgx.graphviz.formatter.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStudioFormatter
implements Formatter<Result> {
    private static final Logger LOG = LoggerFactory.getLogger(DataStudioFormatter.class);
    @Deprecated
    public static final String MAX_NUM_RESULTS_PROPERTY = "pgx.maxResults";
    public static final String TABLE_MAX_RETURNED_ROWS_PROPERTY = "graphviz.formatter.table.maxRows";
    public static final String PAGINATE_START_PROPERTY = "start";
    public static final String PAGINATE_SIZE_PROPERTY = "size";
    public static final String INCLUDE_TABLE = "includeTable";
    public static final String INCLUDE_NETWORK = "includeNetwork";
    public static final int MAX_NUM_RESULTS_NOT_PRESENT_DEFAULT = -1;
    public static final int TABLE_MAX_RETURNED_ROWS_PROPERTY_DEFAULT = 100;
    public static final int PAGINATE_START_DEFAULT = 0;
    public static final int PAGINATE_SIZE_DEFAULT = 100;
    public static final boolean INCLUDE_TABLE_DEFAULT = true;
    public static final boolean INCLUDE_NETWORK_DEFAULT = true;
    private static final ObjectMapper mapper = new ObjectMapper();

    private static int getIntPropertyOrDefault(Map<String, Object> properties, String key, int defaultValue) {
        try {
            return (int)Double.parseDouble(properties.getOrDefault(key, "").toString());
        }
        catch (NumberFormatException n) {
            return defaultValue;
        }
    }

    private static boolean getBooleanPropertyOrDefault(Map<String, Object> properties, String key, boolean defaultValue) {
        return Boolean.parseBoolean(properties.getOrDefault(key, defaultValue).toString());
    }

    @Nonnull
    private static String formatTable(@Nonnull EnhancedResultSet result, int start, int size) {
        Table rs = result.createTableRepresentation();
        return String.join((CharSequence)"\t", rs.getHeader()) + "\n" + StreamSupport.stream(rs.getRows().spliterator(), false).skip(start).limit(size).map(cells -> cells.stream().map(DataStudioFormatter::toStringValue).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
    }

    @Nonnull
    private static String toStringValue(@Nullable Object value) {
        if (value == null) {
            return "NULL";
        }
        String str = value.toString();
        str = str.replaceAll("\\n", "\\\\n");
        str = str.replaceAll("\\t", "\\\\t");
        return str;
    }

    @Nonnull
    public Result format(@Nonnull EnhancedResultSet result, @Nonnull Map<String, Object> properties, ResultGraphCreator creator) throws JsonProcessingException {
        int maxNumResults = DataStudioFormatter.getIntPropertyOrDefault(properties, MAX_NUM_RESULTS_PROPERTY, -1);
        if (maxNumResults == -1) {
            maxNumResults = DataStudioFormatter.getIntPropertyOrDefault(properties, TABLE_MAX_RETURNED_ROWS_PROPERTY, 100);
        }
        int start = DataStudioFormatter.getIntPropertyOrDefault(properties, PAGINATE_START_PROPERTY, 0);
        int size = DataStudioFormatter.getIntPropertyOrDefault(properties, PAGINATE_SIZE_PROPERTY, 100);
        boolean includeTable = DataStudioFormatter.getBooleanPropertyOrDefault(properties, INCLUDE_TABLE, true);
        boolean includeNetwork = DataStudioFormatter.getBooleanPropertyOrDefault(properties, INCLUDE_NETWORK, true);
        if (result.hasGraph() && includeNetwork) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("graph", creator.fromEnhancedResultSet(result, start, size));
            ret.put("name", result.getGraphName());
            ret.put("schema", result.getGraphSchemaName());
            ret.put("resultSetId", result.getResultSetId());
            if (includeTable) {
                ret.put("table", DataStudioFormatter.formatTable(result, start, maxNumResults));
            }
            String json = mapper.writeValueAsString(ret);
            LOG.debug("%network = {}", (Object)json);
            return new Result(ResultType.NETWORK, json);
        }
        if (result.isText()) {
            LOG.debug("%text = {}", (Object)result.getTextResult());
            return new Result(ResultType.TEXT, result.getTextResult());
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("totalNumResults", result.getNumResults());
        ret.put("table", DataStudioFormatter.formatTable(result, start, maxNumResults));
        String json = mapper.writeValueAsString(ret);
        LOG.debug("%table = {}", (Object)json);
        return new Result(ResultType.TABLE, json);
    }

    @Override
    @Nonnull
    public Result format(@Nonnull EnhancedResultSet result, @Nonnull Map<String, Object> properties) throws JsonProcessingException {
        ResultGraph resultGraph = new ResultGraph();
        return this.format(result, properties, resultGraph);
    }
}

