/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.pgx.common.util.ErrorMessages;

public class PgSqlPreconditions {
    private static final int PG_SQL_MINIMUM_MAJOR_VERSION = 23;

    public static void checkSqlPropertyGraphSupport(Connection connection) {
        int oracleMajorVersion;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            oracleMajorVersion = metaData.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new IllegalStateException(ErrorMessages.getMessage("FAILED_TO_DETERMINE_DB_COMPATIBLE_VERSION", e));
        }
        if (oracleMajorVersion < 23) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage("PG_SQL_LOADING_NOT_SUPPORTED", new Object[0]));
        }
    }
}

