/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pgql.lang.PgqlException;

public final class PgqlJdbcRdbmsResultSetMetaData
implements ResultSetMetaData {
    private final oracle.pgql.lang.ResultSetMetaData meta;
    private final int columnCount;

    public PgqlJdbcRdbmsResultSetMetaData(PgqlResultSet rs) throws PgqlException {
        this.meta = rs.getMetaData();
        this.columnCount = this.meta.getColumnCount();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.meta.getColumnName(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkOutBoundIndex(column);
        return 2000;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkOutBoundIndex(column);
        return Object.class.getName();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkOutBoundIndex(column);
        return "object";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    private void checkOutBoundIndex(int column) throws SQLException {
        if (column > this.columnCount) {
            throw new SQLException(String.format("column: %d index out of bounds", column));
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new UnsupportedOperationException("String getSchemaName(int column) not yet implemented");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        throw new UnsupportedOperationException("int getPrecision(int column) not yet implemented");
    }

    @Override
    public int getScale(int column) throws SQLException {
        throw new UnsupportedOperationException("int getScale(int column) not yet implemented");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new UnsupportedOperationException("String getTableName(int column) not yet implemented");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new UnsupportedOperationException("String getCatalogName(int column) not yet implemented");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("<T> T unwrap(Class<T> iface) not yet implemented");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("boolean isWrapperFor(Class<?> iface) not yet implemented");
    }
}

