/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.MutableAuthHeader;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.admin.Control;
import oracle.pgx.api.internal.ApiProvider;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.PgxRealmClient;
import oracle.pgx.api.internal.ProxyServer;
import oracle.pgx.client.PgxRemoteRequest;
import oracle.pgx.client.RemoteControlImpl;
import oracle.pgx.client.RemoteCoreImpl;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.marshalers.GenericMarshaler;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.util.CcTrace;
import oracle.pgx.common.util.DaemonThreadFactory;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.Versions;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.realm.client.RealmClient;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.ssl.SSLInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApiProvider
implements ApiProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClientApiProvider.class);

    public PgxFuture<Control> createControl(ClientConfig config, RealmClient realmClient) {
        if (System.getProperty("java.version").startsWith("1.7.") && System.getProperty("https.protocols") == null) {
            System.setProperty("https.protocols", config.getTlsVersion());
        }
        return ClientApiProvider.createClientContext(config, realmClient).thenApply(RemoteControlImpl::new).thenApply(CcTrace.enableControlTracingIfConfigured((ClientConfig)config));
    }

    public PgxFuture<Core> createCore(ClientConfig config, RealmClient realmClient) {
        return ClientApiProvider.createClientContext(config, realmClient).thenApply(RemoteCoreImpl::new).thenApply(CcTrace.enableCoreTracingIfConfigured((ClientConfig)config));
    }

    public ProxyServer createProxyServer() {
        throw new UnsupportedOperationException("ClientApiProvider does not support the creation of ProxyServer");
    }

    private static final PgxFuture<ClientContext> createClientContext(ClientConfig config, RealmClient realmClient) {
        PoolingHttpClientConnectionManager connectionManager = ClientApiProvider.createConnectionManager().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(config.getRemoteFutureTimeout().intValue(), TimeUnit.MILLISECONDS).build()).setMaxConnPerRoute(config.getMaxClientHttpConnections().intValue()).setMaxConnTotal(config.getMaxClientHttpConnections().intValue()).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager);
        try {
            if (!ClientApiProvider.urlContainsUsernamePassword(config.getCleanedBaseUrl())) {
                MutableAuthHeader mutableAuthHeader = new MutableAuthHeader(() -> ((RealmClient)realmClient).getToken());
                httpClientBuilder.setDefaultHeaders(Collections.singleton(mutableAuthHeader));
            }
        }
        catch (MalformedURLException e) {
            return PgxFuture.exceptionallyCompletedFuture((Throwable)new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_URL_SYNTAX", (Object[])new Object[]{config.getCleanedBaseUrl()}), e));
        }
        ClientApiProvider.setProxy(config, httpClientBuilder);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        Cookie instanceStickyCookie = ClientApiProvider.getInstanceStickyCookie(realmClient, config, httpClient);
        return ClientApiProvider.versionCheck(config, httpClient, instanceStickyCookie).thenCompose(arg -> ClientApiProvider.getCsrfToken(config, httpClient, instanceStickyCookie)).thenApply(csrfToken -> new ClientContext(config, httpClient, ClientExecutorServiceHolder.EXECUTOR_SERVICE, (String)csrfToken, instanceStickyCookie));
    }

    private static Cookie getInstanceStickyCookie(RealmClient realmClient, ClientConfig config, CloseableHttpClient httpClient) {
        Cookie cookie = realmClient.getPgxInstanceStickyCookie();
        if (cookie != null) {
            return cookie;
        }
        if (!(realmClient instanceof PgxRealmClient)) {
            return null;
        }
        cookie = ClientApiProvider.getPgxInstanceStickyCookie(config, httpClient);
        ((PgxRealmClient)realmClient).setInstanceStickyCookie(cookie);
        return cookie;
    }

    private static Cookie getPgxInstanceStickyCookie(ClientConfig config, CloseableHttpClient httpClient) {
        String isRunningUrl = config.getCleanedBaseUrl() + "/isRunning";
        BasicCookieStore cookieStore = new BasicCookieStore();
        try {
            ClassicHttpResponse response = (ClassicHttpResponse)Executor.newInstance((CloseableHttpClient)httpClient).use((CookieStore)cookieStore).execute(Request.get((String)isRunningUrl)).returnResponse();
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (Cookie cookie : cookieStore.getCookies()) {
            if (!cookie.getName().equals("PGX_INSTANCE_STICKY_COOKIE")) continue;
            LOG.debug("reading client sticky cookie {} from request", (Object)cookie.getValue());
            return cookie;
        }
        return null;
    }

    private static boolean urlContainsUsernamePassword(String baseUrl) throws MalformedURLException {
        return new URL(baseUrl).getUserInfo() != null;
    }

    private static void setProxy(ClientConfig config, HttpClientBuilder httpClientBuilder) {
        if (StaticConfig.get().isRelease().booleanValue()) {
            return;
        }
        if (System.getenv("ZAP_HTTP_PROXY") != null) {
            URI httpProxy = URI.create(System.getenv("ZAP_HTTP_PROXY"));
            HttpHost httpHost = new HttpHost(httpProxy.getScheme(), httpProxy.getHost(), httpProxy.getPort());
            LOG.info("setting up zap http proxy: {}", (Object)httpProxy);
            httpClientBuilder.setProxy(httpHost);
        }
    }

    private static final PoolingHttpClientConnectionManagerBuilder createConnectionManager() {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException sSLInitializationException) {
            // empty catch block
        }
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory()));
    }

    private static PgxFuture<Void> versionCheck(ClientConfig config, CloseableHttpClient httpClient, Cookie clientStickyCookie) {
        return ClientApiProvider.asyncRequest(() -> {
            VersionInfo serverVersionInfo;
            String serverApiVersion;
            VersionInfo clientVersionInfo = VersionInfo.getInstance((String)"PGX_CLIENT");
            String clientApiVersion = clientVersionInfo.getApiVersion();
            if (!Versions.isCompatible((String)clientApiVersion, (String)(serverApiVersion = (serverVersionInfo = ClientApiProvider.getServerVersionInfo(config, httpClient, clientStickyCookie)).getApiVersion()), (boolean)StaticConfig.get().isEnablePluginVersionChecks())) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"VERSION_MISMATCH_SERVER", (Object[])new Object[]{serverApiVersion, clientApiVersion}));
            }
            if (clientApiVersion != null && serverApiVersion != null && !clientApiVersion.equalsIgnoreCase(serverApiVersion)) {
                LOG.warn("detected version mismatch between client (" + clientApiVersion + ") and server (" + serverApiVersion + ") api versions");
            }
            return null;
        });
    }

    private static VersionInfo getServerVersionInfo(ClientConfig config, CloseableHttpClient httpClient, Cookie clientStickyCookie) throws RemoteUtils.RequestPendingException, IOException {
        String json;
        String versionUrl = config.getCleanedBaseUrl() + "/version?extendedInfo=true";
        LOG.debug("checking server version from {}", (Object)versionUrl);
        Executor executor = Executor.newInstance((CloseableHttpClient)httpClient);
        if (clientStickyCookie != null) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            cookieStore.addCookie(clientStickyCookie);
            executor.use((CookieStore)cookieStore);
        }
        if ((json = (String)executor.execute(Request.get((String)versionUrl)).handleResponse(response -> {
            HttpEntity entity = response.getEntity();
            String jsonData = EntityUtils.toString((HttpEntity)entity);
            ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
            int status = response.getCode();
            if (status == 202) {
                return null;
            }
            if (status != 200) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"FAILED_TO_CONNECT_WRONG_STATUS", (Object[])new Object[]{config.getCleanedBaseUrl(), status, jsonData}));
            }
            if (contentType == null || !contentType.getMimeType().equals(ContentType.APPLICATION_JSON.getMimeType())) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"FAILED_TO_CONNECT_WRONG_CONTENT_TYPE", (Object[])new Object[]{config.getCleanedBaseUrl(), contentType, jsonData}));
            }
            return jsonData;
        })) == null) {
            throw new RemoteUtils.RequestPendingException();
        }
        try {
            GenericMarshaler marshaler = new GenericMarshaler(VersionInfo.class);
            return (VersionInfo)marshaler.unmarshal(json);
        }
        catch (JsonParseException e) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"FAILED_TO_CONNECT", (Object[])new Object[]{config.getCleanedBaseUrl(), json}), e);
        }
    }

    private static PgxFuture<String> getCsrfToken(ClientConfig config, CloseableHttpClient httpClient, Cookie clientStickyCookie) {
        return ClientApiProvider.asyncRequest(() -> {
            String tokenUrl = config.getCleanedBaseUrl() + "/token";
            LOG.debug("requesting CSRF token from {}", (Object)tokenUrl);
            BasicCookieStore cookieStore = new BasicCookieStore();
            if (clientStickyCookie != null) {
                cookieStore.addCookie(clientStickyCookie);
            }
            Executor executor = Executor.newInstance((CloseableHttpClient)httpClient).use((CookieStore)cookieStore);
            RemoteUtils.parse(executor.execute(Request.get((String)tokenUrl)), Marshalers.VOID_MARSHALER);
            for (Cookie cookie : cookieStore.getCookies()) {
                if (!cookie.getName().equals("_csrf_token")) continue;
                return cookie.getValue();
            }
            throw new IllegalStateException("server did not set CSRF cookie");
        });
    }

    private static <T> PgxFuture<T> asyncRequest(PgxRemoteRequest<T> request) {
        return RemoteUtils.asyncRequest(ClientExecutorServiceHolder.EXECUTOR_SERVICE, request);
    }

    private static class ClientExecutorServiceHolder {
        public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory("pgx-client-thread"));

        private ClientExecutorServiceHolder() {
        }
    }
}

