/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jshell;

import java.io.Console;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import oracle.pgx.api.Analyst;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.admin.StartupLogging;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.AuthConsole;
import oracle.pgx.common.util.StringUtils;
import oracle.pgx.common.util.SystemUtils;
import oracle.pgx.common.util.Versions;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.ClientConfigBuilder;
import oracle.pgx.config.InteractionMode;
import oracle.pgx.jshell.Arguments;
import oracle.pgx.jshell.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Shell.class);
    private static final String ESC = "\u001b";
    private static final String RED = "31";
    private static final String BLACK = "0";
    private static final String BOLD = "1";
    private static final String RESET = "0";
    private static final String RED_COMMAND = "\u001b[31m";
    private static final String BOLD_COMMAND = "\u001b[0;1m";
    private static final String RESET_COMMAND = "\u001b[0m";

    public static ServerInstance createInstance(Arguments arguments) throws ExecutionException, InterruptedException, IOException {
        ClientConfigBuilder builder;
        ServerInstance instance;
        String password = null;
        if (StringUtils.isNotEmpty((String)arguments.truststore)) {
            System.setProperty("javax.net.ssl.trustStore", arguments.truststore);
        }
        if (StringUtils.isNotEmpty((String)arguments.keystore)) {
            char[] passwordArray = Utils.getKeyStorePassword(arguments.keystore);
            password = passwordArray != null ? new String(passwordArray) : null;
        }
        String token = null;
        if (StringUtils.isNotEmpty((String)arguments.baseUrl) && StringUtils.isNotEmpty((String)arguments.keystore) && arguments.keystoreAuthToken) {
            try {
                token = AuthCertUtils.getPasswordFromKeystore((String)arguments.keystore, (char[])(password == null ? null : password.toCharArray()), (String)"AuthorizationToken");
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOG.error(e.getMessage());
                String message = "error reading authentication token from keystore " + arguments.keystore;
                Utils.printLineToConsole(message);
                throw new ExecutionException(message, e);
            }
        }
        if ((instance = Pgx.getInstance((ClientConfig)(builder = ClientConfigBuilder.forBaseUrl((String)arguments.baseUrl).setPrefetchSize(arguments.prefetchSize).setUploadBatchSize(arguments.uploadBatchSize).setRemoteFutureTimeout(arguments.remoteFutureTimoutMillis).setRemoteFuturePendingRetryInterval(arguments.pendingRetryIntervalMillis).setEnableCctrace(arguments.cctrace).setMaxClientHttpConnections(arguments.maxConnections).setClientServerInteractionMode(InteractionMode.valueOf((String)arguments.interactionMode.toUpperCase())).setAccessToken(token)).build())).isEmbeddedInstance() && !instance.isEngineRunning()) {
            if (arguments.pgxConf != null) {
                try (FileInputStream is = new FileInputStream(arguments.pgxConf);){
                    instance.startEngine((InputStream)is);
                }
            } else {
                instance.startEngine();
            }
        }
        return instance;
    }

    private static void printLineToConsole(String message) {
        Console console = System.console();
        if (console != null) {
            console.printf("%s\n", message);
        }
    }

    private static char[] getKeyStorePassword(String keystore) throws ExecutionException {
        try {
            return AuthCertUtils.checkJksKeystorePassword((String)keystore, (AuthConsole)AuthCertUtils.getSystemConsole(), (boolean)true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot open keystore " + keystore, e);
        }
    }

    private static char[] getUsernamePassword(String username) throws ExecutionException {
        try {
            return AuthCertUtils.promptUserForPassword((String)("enter password for user " + username + " (press Enter for no password)"), (AuthConsole)AuthCertUtils.getSystemConsole());
        }
        catch (UnsupportedOperationException e) {
            LOG.error(e.getMessage());
            String message = "cannot authenticate user " + username;
            Utils.printLineToConsole(message);
            throw new ExecutionException(message, e);
        }
    }

    public static PgxSession createSession(ServerInstance instance, Arguments arguments) throws ExecutionException, InterruptedException {
        final PgxSession session = instance.createSession("pgxShell", arguments.idleTimeoutSecs, arguments.taskTimeoutSecs, TimeUnit.SECONDS);
        String secretStore = arguments.secretStore;
        if (secretStore != null) {
            session.registerKeystore(secretStore, Utils.getKeyStorePassword(secretStore));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (session != null) {
                    session.close();
                }
            }
        });
        return session;
    }

    public static Analyst createAnalyst(PgxSession session) {
        return session.createAnalyst();
    }

    public static void printVersionBanner(ServerInstance instance) {
        if (instance != null) {
            String versionInfo = null;
            String shellVersion = Versions.getVersionOf(Shell.class);
            try {
                versionInfo = StartupLogging.createVersionInfoString(Utils::red, (String)shellVersion, (ServerInstance)instance);
            }
            catch (Exception e) {
                LOG.warn("could not retrieve version info from server", (Throwable)e);
            }
            System.out.println(versionInfo);
        }
    }

    public static void printHelpInfo() {
        System.out.println("For an introduction type: " + Utils.bold("/help intro"));
    }

    public static void printAvailableVariables() {
        String instance = Utils.bold("instance");
        String session = Utils.bold("session");
        String analyst = Utils.bold("analyst");
        System.out.println("Variables " + instance + ", " + session + ", and " + analyst + " ready to use.");
    }

    public static String red(String text) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return text;
        }
        return RED_COMMAND + text + RESET_COMMAND;
    }

    public static String bold(String text) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return text;
        }
        return BOLD_COMMAND + text + RESET_COMMAND;
    }

    public static String[] splitArgs(String args) {
        String[] argsArray = args.length() == 0 ? new String[]{} : args.split("\\s+");
        return argsArray;
    }
}

