from pkg_resources import get_distribution

from . import dump, model_selection
from .builtin_datasets import get_dataset_dir

from .dataset import Dataset

from .prediction_algorithms import (
    AlgoBase,
    BaselineOnly,
    CoClustering,
    KNNBaseline,
    KNNBasic,
    KNNWithMeans,
    KNNWithZScore,
    NMF,
    NormalPredictor,
    Prediction,
    PredictionImpossible,
    SlopeOne,
    SVD,
    SVDpp,
)
from .reader import Reader
from .trainset import Trainset

__all__ = [
    "AlgoBase",
    "NormalPredictor",
    "BaselineOnly",
    "KNNBasic",
    "KNNWithMeans",
    "KNNBaseline",
    "SVD",
    "SVDpp",
    "NMF",
    "SlopeOne",
    "CoClustering",
    "PredictionImpossible",
    "Prediction",
    "Dataset",
    "Reader",
    "Trainset",
    "dump",
    "KNNWithZScore",
    "get_dataset_dir",
    "model_selection",
]

__version__ = get_distribution("scikit-surprise").version
