from dlubal.api.common import common_pb2 as _common_pb2
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class BoreholeType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    BOREHOLE_TYPE_PHANTOM: _ClassVar[BoreholeType]
    BOREHOLE_TYPE_STANDARD: _ClassVar[BoreholeType]
BOREHOLE_TYPE_PHANTOM: BoreholeType
BOREHOLE_TYPE_STANDARD: BoreholeType

class Borehole(_message.Message):
    __slots__ = ("no", "type", "user_defined_name_enabled", "name", "coordinates", "coordinate_0", "coordinate_1", "coordinate_2", "import_coordinate_z_from_terrain", "groundwater", "groundwater_ordinate", "layers_table", "layers_thickness_sum", "comment", "id_for_export_import", "metadata_for_export_import")
    NO_FIELD_NUMBER: _ClassVar[int]
    TYPE_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_NAME_ENABLED_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    COORDINATES_FIELD_NUMBER: _ClassVar[int]
    COORDINATE_0_FIELD_NUMBER: _ClassVar[int]
    COORDINATE_1_FIELD_NUMBER: _ClassVar[int]
    COORDINATE_2_FIELD_NUMBER: _ClassVar[int]
    IMPORT_COORDINATE_Z_FROM_TERRAIN_FIELD_NUMBER: _ClassVar[int]
    GROUNDWATER_FIELD_NUMBER: _ClassVar[int]
    GROUNDWATER_ORDINATE_FIELD_NUMBER: _ClassVar[int]
    LAYERS_TABLE_FIELD_NUMBER: _ClassVar[int]
    LAYERS_THICKNESS_SUM_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    type: BoreholeType
    user_defined_name_enabled: bool
    name: str
    coordinates: _common_pb2.Vector3d
    coordinate_0: float
    coordinate_1: float
    coordinate_2: float
    import_coordinate_z_from_terrain: bool
    groundwater: bool
    groundwater_ordinate: float
    layers_table: ArrayOfBoreholeLayersTable
    layers_thickness_sum: float
    comment: str
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., type: _Optional[_Union[BoreholeType, str]] = ..., user_defined_name_enabled: bool = ..., name: _Optional[str] = ..., coordinates: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., coordinate_0: _Optional[float] = ..., coordinate_1: _Optional[float] = ..., coordinate_2: _Optional[float] = ..., import_coordinate_z_from_terrain: bool = ..., groundwater: bool = ..., groundwater_ordinate: _Optional[float] = ..., layers_table: _Optional[_Union[ArrayOfBoreholeLayersTable, _Mapping]] = ..., layers_thickness_sum: _Optional[float] = ..., comment: _Optional[str] = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...

class ArrayOfBoreholeLayersTable(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...
