"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.patchModule = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
function patchModule(module, expectedVersion) {
    let moduleRoot;
    try {
        moduleRoot = require.resolve(module + '/package.json');
    }
    catch (e) {
        return; // module not in closure
    }
    const pkg = JSON.parse(fs_1.readFileSync(moduleRoot, 'utf-8'));
    if (pkg.version !== expectedVersion) {
        throw new Error(`this patch only applies to AWS CDK version ${expectedVersion}. got ${pkg.version}`);
    }
    const layerdir = path_1.join(path_1.dirname(moduleRoot), 'layer');
    if (!fs_1.existsSync(layerdir)) {
        fs_1.mkdirSync(layerdir);
        fs_1.writeFileSync(path_1.join(layerdir, 'Dockerfile'), '# dummy');
    }
}
exports.patchModule = patchModule;
//# sourceMappingURL=data:application/json;base64,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