"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceGroup = exports.InstanceGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudphone_generated_1 = require("./cloudphone.generated");
Object.defineProperty(exports, "InstanceGroupProperty", { enumerable: true, get: function () { return cloudphone_generated_1.RosInstanceGroup; } });
/**
 * A ROS resource type:  `ALIYUN::CloudPhone::InstanceGroup`
 */
class InstanceGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::CloudPhone::InstanceGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstanceGroup = new cloudphone_generated_1.RosInstanceGroup(this, id, {
            keyPairName: props.keyPairName,
            description: props.description,
            amount: props.amount,
            securityGroupId: props.securityGroupId,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            autoPay: props.autoPay,
            instanceName: props.instanceName,
            eipBandwidth: props.eipBandwidth,
            chargeType: props.chargeType,
            imageId: props.imageId,
            vncPassword: props.vncPassword,
            tag: props.tag,
            instanceType: props.instanceType,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
            resolution: props.resolution,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstanceGroup;
        this.attrInstanceIds = rosInstanceGroup.attrInstanceIds;
        this.attrOrderId = rosInstanceGroup.attrOrderId;
        this.attrTradePrice = rosInstanceGroup.attrTradePrice;
    }
}
exports.InstanceGroup = InstanceGroup;
//# sourceMappingURL=data:application/json;base64,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