"use strict";
(self["webpackChunkworkbench_jupyterlab"] = self["webpackChunkworkbench_jupyterlab"] || []).push([["lib_index_js"],{

/***/ "./images/posit-icon-fullcolor.svg":
/*!*****************************************!*\
  !*** ./images/posit-icon-fullcolor.svg ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 26.4.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t width=\"184px\" height=\"182.5px\" viewBox=\"0 0 184 182.5\" style=\"enable-background:new 0 0 184 182.5;\" xml:space=\"preserve\">\n<style type=\"text/css\">\n\t.st0{fill:#EE6331;}\n\t.st1{fill:#447099;}\n</style>\n<g id=\"posit-logo\">\n\t<polygon id=\"fullLogo-8\" class=\"st0\" points=\"38,73.1 46.2,69.5 82.9,53.3 90.9,49.7 179.7,10.5 179.7,57.8 143.8,73.1 135.7,69.5 \n\t\t173.2,53.5 173.2,20.5 98.9,53.3 90.9,56.8 54.3,73 46.2,76.6 20.3,88 20.3,96.5 45.8,107.8 53.9,111.4 91.5,128 99.5,131.5 \n\t\t173.2,164.1 173.2,130.7 136.1,114.9 144.2,111.3 179.7,126.4 179.7,174 91.5,135.1 83.6,131.6 45.8,114.9 37.6,111.3 13.8,100.7 \n\t\t13.8,83.8 \t\"/>\n\t<polygon class=\"st0\" points=\"99.2,92.1 135.6,76.6 127.5,73 82.6,92.1 127.9,111.4 136,107.8 \t\"/>\n\t<polygon id=\"fullLogo-9\" class=\"st1\" points=\"45.8,107.8 53.9,111.4 90.9,95.6 82.7,92.1 \t\"/>\n\t<polygon id=\"fullLogo-10\" class=\"st1\" points=\"54.3,73 46.2,76.6 82.7,92.1 90.9,88.6 \t\"/>\n\t<polygon id=\"fullLogo-11\" class=\"st1\" points=\"143.8,73.1 135.7,69.5 98.9,53.3 90.9,49.7 2.1,10.5 2.1,57.8 38,73.1 46.2,69.5 \n\t\t8.6,53.5 8.6,20.5 82.9,53.3 90.9,56.8 127.5,73 135.6,76.6 161.6,88 161.6,96.5 136.1,107.8 127.9,111.4 90.4,128 82.4,131.5 \n\t\t8.6,164.1 8.6,130.7 45.8,114.9 37.6,111.3 2.1,126.4 2.1,174 90.3,135.1 98.3,131.6 136.1,114.9 144.2,111.3 168,100.7 168,83.8 \t\n\t\t\"/>\n</g>\n</svg>\n");

/***/ }),

/***/ "./images/posit-icon-unstyled.svg":
/*!****************************************!*\
  !*** ./images/posit-icon-unstyled.svg ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 26.4.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" viewBox=\"0 0 184 182.5\" xml:space=\"preserve\">\n<g id=\"posit-logo\">\n\t<polygon id=\"fullLogo-8\" points=\"38,73.1 46.2,69.5 82.9,53.3 90.9,49.7 179.7,10.5 179.7,57.8 143.8,73.1 135.7,69.5 \n\t\t173.2,53.5 173.2,20.5 98.9,53.3 90.9,56.8 54.3,73 46.2,76.6 20.3,88 20.3,96.5 45.8,107.8 53.9,111.4 91.5,128 99.5,131.5 \n\t\t173.2,164.1 173.2,130.7 136.1,114.9 144.2,111.3 179.7,126.4 179.7,174 91.5,135.1 83.6,131.6 45.8,114.9 37.6,111.3 13.8,100.7 \n\t\t13.8,83.8 \t\"/>\n\t<polygon points=\"99.2,92.1 135.6,76.6 127.5,73 82.6,92.1 127.9,111.4 136,107.8 \t\"/>\n\t<polygon id=\"fullLogo-9\" points=\"45.8,107.8 53.9,111.4 90.9,95.6 82.7,92.1 \t\"/>\n\t<polygon id=\"fullLogo-10\" points=\"54.3,73 46.2,76.6 82.7,92.1 90.9,88.6 \t\"/>\n\t<polygon id=\"fullLogo-11\" points=\"143.8,73.1 135.7,69.5 98.9,53.3 90.9,49.7 2.1,10.5 2.1,57.8 38,73.1 46.2,69.5 \n\t\t8.6,53.5 8.6,20.5 82.9,53.3 90.9,56.8 127.5,73 135.6,76.6 161.6,88 161.6,96.5 136.1,107.8 127.9,111.4 90.4,128 82.4,131.5 \n\t\t8.6,164.1 8.6,130.7 45.8,114.9 37.6,111.3 2.1,126.4 2.1,174 90.3,135.1 98.3,131.6 136.1,114.9 144.2,111.3 168,100.7 168,83.8 \t\n\t\t\"/>\n</g>\n</svg>\n");

/***/ }),

/***/ "./lib/constants.js":
/*!**************************!*\
  !*** ./lib/constants.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "kHeartbeatEndpoint": () => (/* binding */ kHeartbeatEndpoint),
/* harmony export */   "kQuartoApp": () => (/* binding */ kQuartoApp),
/* harmony export */   "kServerEndpoint": () => (/* binding */ kServerEndpoint),
/* harmony export */   "kShinyApp": () => (/* binding */ kShinyApp),
/* harmony export */   "kUrlEndpoint": () => (/* binding */ kUrlEndpoint)
/* harmony export */ });
/*
 * constants.ts
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */
// This file shares variables with './workbench_jupyterlab/constants.py'
// Changes made to this file may need to be duplicated there.
// default process names
const kShinyApp = 'Shiny Project';
const kQuartoApp = 'Quarto Project';
// workbench_jupyterlab server extension endpoints
const kServerEndpoint = 'servers';
const kUrlEndpoint = 'url';
const kHeartbeatEndpoint = 'heartbeat';


/***/ }),

/***/ "./lib/disconnectAlert.js":
/*!********************************!*\
  !*** ./lib/disconnectAlert.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WorkbenchDisconnectWidget": () => (/* binding */ WorkbenchDisconnectWidget),
/* harmony export */   "setupDisconnectNotification": () => (/* binding */ setupDisconnectNotification)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _disconnectMonitor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./disconnectMonitor */ "./lib/disconnectMonitor.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/*
 * disconnectAlert.tsx
 *
 * Copyright (C) 2023 by Posit Software, PBC
 *
 */



function WorkbenchDisconnectWidget() {
    const [message, setMessage] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [visible, setVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [onAccept, setOnAccept] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
    const [buttonFocus, setButtonFocus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1);
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        let timestamp = 0;
        let timerId = -1;
        const updateMessage = () => {
            window.clearTimeout(timerId);
            const timeDiff = Date.now() - timestamp;
            const seconds = Math.floor(timeDiff / 1000);
            const minutes = Math.floor(seconds / 60);
            setMessage(`The underlying JupyterLab connection has been closed for <span aria-role="timer">${minutes}:${String(seconds % 60).padStart(2, '0')}</span>.<br>Attempting to reconnect...`);
            timerId = window.setTimeout(() => {
                updateMessage();
            }, 1000);
        };
        const listener = params => {
            if (typeof params.timestamp === 'number') {
                timestamp = params.timestamp;
            }
            if (typeof params.onAccept === 'function') {
                setOnAccept(() => params.onAccept);
            }
            if (typeof params.dismiss === 'boolean') {
                setVisible(!params.dismiss);
                if (params.dismiss) {
                    window.clearTimeout(timerId);
                }
                else {
                    updateMessage();
                }
            }
        };
        const unlisten = (0,_disconnectMonitor__WEBPACK_IMPORTED_MODULE_2__.listen)(listener);
        return (() => {
            window.clearTimeout(timerId);
            unlisten();
        });
    }, []);
    const updateFocus = (direction = 0) => {
        if (!ref.current) {
            return;
        }
        const el = ref.current;
        const buttons = el.querySelectorAll('button');
        let currentFocus = buttonFocus;
        if (direction) {
            currentFocus = (buttons.length + currentFocus + Math.sign(direction)) % buttons.length;
        }
        buttons[currentFocus].focus();
        setButtonFocus(currentFocus);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!ref.current) {
            return;
        }
        const el = ref.current;
        el.style.display = '';
        const anim = el.animate([
            {
                opacity: visible ? 0 : 1
            },
            {
                opacity: visible ? 1 : 0
            }
        ], 150);
        const onFinish = () => {
            el.style.display = visible ? '' : 'none';
            if (visible) {
                updateFocus();
            }
        };
        anim.addEventListener('finish', onFinish);
        return (() => {
            anim.removeEventListener('finish', onFinish);
        });
    }, [visible]);
    const onKeyDown = (evt) => {
        switch (evt.code) {
            case 'ArrowLeft':
            case 'ArrowRight':
            case 'Tab':
                evt.preventDefault();
                evt.stopPropagation();
                updateFocus(1);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { ref: ref, id: "workbench-disconnect-alert", className: "jp-workbench-disconnect-alert jp-Dialog-content", style: { display: 'none' }, tabIndex: 0, "aria-role": "alertdialog", "aria-hidden": !visible, "aria-describedby": "workbench-disconnect-alert-message", onKeyDown: onKeyDown },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { id: "workbench-disconnect-alert-message", style: { gridArea: 'message' }, dangerouslySetInnerHTML: { __html: message } }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { id: "workbench-disconnect-alert-dismiss", style: { gridArea: 'dismiss' }, className: "jp-Dialog-button jp-mod-accept jp-mod-styled", onClick: () => { onAccept(); }, "aria-label": "Return to Workbench Home" }, "Workbench Home"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { id: "workbench-disconnect-alert-retry", style: { gridArea: 'retry' }, className: "jp-Dialog-button jp-mod-reject jp-mod-styled", onClick: () => { (0,_disconnectMonitor__WEBPACK_IMPORTED_MODULE_2__.disconnectRetry)(onAccept); }, "aria-label": "Retry connection now" }, "Retry Now")));
}
function setupDisconnectNotification() {
    const id = 'workbench-disconnect-layer';
    let host = document.getElementById(id);
    if (!host) {
        host = document.createElement('div');
        host.id = id;
        host.style.cssText = `
      position: absolute;
      bottom: 26px;
      right: 34px;
      z-index: 1000;
    `;
        document.body.append(host);
    }
    react_dom__WEBPACK_IMPORTED_MODULE_1__.render(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(WorkbenchDisconnectWidget, null), host);
}


/***/ }),

/***/ "./lib/disconnectMonitor.js":
/*!**********************************!*\
  !*** ./lib/disconnectMonitor.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "disconnectRetry": () => (/* binding */ disconnectRetry),
/* harmony export */   "heartbeat": () => (/* binding */ heartbeat),
/* harmony export */   "listen": () => (/* binding */ listen),
/* harmony export */   "stopHeartbeat": () => (/* binding */ stopHeartbeat)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./handler */ "./lib/handler.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./lib/constants.js");
/*
 * disconnectMonitor.ts
 *
 * Copyright (C) 2023 by Posit Software, PBC
 *
 */



let heartbeatId = -1;
const retryIntervals = [2, 2, 2, 2, 5, 5, 10, 20, 30];
let retryCount = 0;
let retryTimer = -1;
let disconnectTimestamp = 0;
let existingDialog;
async function displayModal(onAccept) {
    // dialog already open, do not re-open
    // it is cleared when the user responds to input
    if (existingDialog) {
        return;
    }
    const acceptButton = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.createButton({
        accept: true,
        label: 'Workbench Home'
    });
    const retryButton = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.createButton({
        accept: false,
        label: 'Retry Now'
    });
    existingDialog = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog({
        body: 'The underlying JupyterLab connection has been closed.',
        title: 'Disconnected from Workbench',
        hasClose: false,
        buttons: [acceptButton, retryButton]
    });
    const result = await existingDialog.launch();
    if (result.button === acceptButton) {
        onAccept();
    }
    else if (result.button === retryButton) {
        disconnectRetry(onAccept);
    }
    existingDialog.close();
    existingDialog = undefined;
}
const listeners = new Set();
function listen(listener) {
    const unlisten = () => {
        listeners.delete(listener);
    };
    listeners.add(listener);
    return unlisten;
}
function upsertNotification(onAccept) {
    for (const listener of listeners.values()) {
        listener({
            timestamp: disconnectTimestamp,
            dismiss: false,
            onAccept
        });
    }
}
function dismissNotification() {
    for (const listener of listeners) {
        listener({
            dismiss: true
        });
    }
}
function disconnectRetry(returnHome) {
    // assume that we are dead in the water, start a series of delays to re-poll for connection
    // fire an event to the homepage to display an error
    const retryPoll = async (currentTry = retryCount) => {
        retryCount = currentTry;
        window.clearTimeout(retryTimer);
        try {
            const result = await (0,_handler__WEBPACK_IMPORTED_MODULE_1__.requestAPI)(_constants__WEBPACK_IMPORTED_MODULE_2__.kHeartbeatEndpoint);
            if (!result.result) {
                throw new Error('response was invalid');
            }
            // if this succeeds then cancel retries and resume
            retryCount = 0;
            dismissNotification();
            heartbeat(returnHome);
        }
        catch (err) {
            // it's severe if we reach the end of retry intervals
            if (currentTry > 1) {
                if (retryCount < retryIntervals.length - 1) {
                    // show / update notification
                    upsertNotification(returnHome);
                }
                else {
                    // show modal
                    // this will just pause everything until the user does something about it,
                    // since modals cannot be closed remotely
                    dismissNotification();
                    await displayModal(returnHome);
                }
            }
            retryTimer = window.setTimeout(() => { retryPoll(Math.min(currentTry + 1, retryIntervals.length - 1)); }, retryIntervals[currentTry] * 1000);
        }
    };
    retryPoll();
}
function heartbeat(returnHome) {
    window.clearTimeout(heartbeatId);
    heartbeatId = window.setTimeout(async () => {
        try {
            const result = await (0,_handler__WEBPACK_IMPORTED_MODULE_1__.requestAPI)(_constants__WEBPACK_IMPORTED_MODULE_2__.kHeartbeatEndpoint);
            if (!result.result) {
                throw new Error('response was invalid');
            }
            heartbeat(returnHome);
        }
        catch (err) {
            disconnectTimestamp = Date.now();
            disconnectRetry(returnHome);
        }
    }, 30000);
}
function stopHeartbeat() {
    window.clearTimeout(heartbeatId);
}


/***/ }),

/***/ "./lib/handler.js":
/*!************************!*\
  !*** ./lib/handler.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "requestAPI": () => (/* binding */ requestAPI)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/*
 * handler.ts
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */


/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endPoint = '', init = {}) {
    // Make request to Jupyter API
    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
    const requestUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(settings.baseUrl, 'workbench-jupyterlab', // API Namespace
    endPoint);
    let response;
    response = await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(requestUrl, init, settings);
    let data = await response.text();
    if (data.length > 0) {
        try {
            data = JSON.parse(data);
        }
        catch (error) {
            console.log('Not a JSON response body.', response);
        }
    }
    if (!response.ok) {
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response, data.message || data);
    }
    return data;
}


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _images_posit_icon_fullcolor_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../images/posit-icon-fullcolor.svg */ "./images/posit-icon-fullcolor.svg");
/* harmony import */ var _images_posit_icon_unstyled_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../images/posit-icon-unstyled.svg */ "./images/posit-icon-unstyled.svg");
/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./widget */ "./lib/widget.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _disconnectMonitor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./disconnectMonitor */ "./lib/disconnectMonitor.js");
/* harmony import */ var _disconnectAlert__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./disconnectAlert */ "./lib/disconnectAlert.js");
/*
 * index.ts
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */









let homeUrl = '/home';
const rstudioIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.LabIcon({
    name: 'workbench_jupyterlab:home-icon',
    svgstr: _images_posit_icon_fullcolor_svg__WEBPACK_IMPORTED_MODULE_4__["default"],
});
const rstudioPanelIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.LabIcon({
    name: 'workbench_jupyterlab:panel-icon',
    svgstr: _images_posit_icon_unstyled_svg__WEBPACK_IMPORTED_MODULE_5__["default"],
});
function returnHome() {
    location.assign(homeUrl);
}
function registerCommands(app, palette) {
    var regex = /(s\/[\w]{5}[\w]{8}[\w]{8}\/)/g;
    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
    homeUrl = settings.baseUrl.replace(regex, 'home/');
    // Register command to return to RStudio Workbench home
    const command = 'workbench_jupyterlab:return-home';
    app.commands.addCommand(command, {
        label: 'Return to Posit Workbench Home',
        caption: 'Return to Posit Workbench Home',
        execute: returnHome
    });
    palette.addItem({ command, category: 'Posit Workbench' });
}
function addRStudioIcon(app) {
    // Add RStudio icon that returns the user to home to menu bar
    const rstudio_widget = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget();
    rstudio_widget.id = 'rsw-icon';
    rstudio_widget.node.onclick = returnHome;
    rstudioIcon.element({
        container: rstudio_widget.node,
        justify: 'center',
        margin: '2px 5px 2px 5px',
        height: 'auto',
        width: '20px',
    });
    app.shell.add(rstudio_widget, 'top', { rank: 1 });
}
function addSideBar(app) {
    // Add the RSW side bar widget to the left panel
    const panel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Panel();
    panel.id = 'RStudio-Workbench-tab';
    panel.title.icon = rstudioPanelIcon;
    panel.addWidget(new _widget__WEBPACK_IMPORTED_MODULE_6__.RStudioWorkbenchWidget());
    app.shell.add(panel, 'left', { rank: 501 });
}
function activate(app, palette) {
    registerCommands(app, palette);
    addRStudioIcon(app);
    addSideBar(app);
    (0,_disconnectMonitor__WEBPACK_IMPORTED_MODULE_7__.heartbeat)(returnHome);
    (0,_disconnectAlert__WEBPACK_IMPORTED_MODULE_8__.setupDisconnectNotification)();
}
function deactivate() {
    (0,_disconnectMonitor__WEBPACK_IMPORTED_MODULE_7__.stopHeartbeat)();
}
const plugin = {
    // Initialization data for the workbench_jupyterlab extension.
    id: 'workbench-jupyterlab',
    autoStart: true,
    requires: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ICommandPalette],
    activate,
    deactivate
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);


/***/ }),

/***/ "./lib/proxiedServersComponent.js":
/*!****************************************!*\
  !*** ./lib/proxiedServersComponent.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProxiedServersComponent": () => (/* binding */ ProxiedServersComponent),
/* harmony export */   "Server": () => (/* binding */ Server)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/*
 * proxiedServersComponent.tsx
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */
// This file shares variables with './workbench_jupyterlab/constants.py'


const TitleComponent = (props) => {
    const headerId = ('title_component_' + props.title).replace(/\s+/g, '_');
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("header", { id: headerId }, props.title)));
};
const ServerComponent = (props) => {
    const hyperlinkId = 'server_link_' + props.server.html_id;
    const liId = 'server_component_' + props.server.html_id;
    const serverNameId = 'server_name_' + props.server.html_id;
    const serverInfoId = 'server_info_' + props.server.html_id;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, { "aria-role": 'link', "aria-label": 'Open link for proxied server ' + props.server.label },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { id: hyperlinkId, target: "_blank", title: props.server.title, href: props.server.securePath },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { id: liId },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.launcherIcon.react, { paddingRight: 5 }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { id: serverNameId, className: 'jp-ServerName' }, props.server.label),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { id: serverInfoId, className: 'jp-ServerInfo' },
                    props.server.ip,
                    ":",
                    props.server.port)))));
};
class ProxiedServersComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
    }
    render() {
        const serverItems = this.props.servers.map((server) => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ServerComponent, { server: server }));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TitleComponent, { title: 'Proxied Servers' }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { id: 'proxied_servers_list' }, serverItems))));
    }
}
class Server {
    constructor(pid, name, port, ip, securePath) {
        this.pid = pid;
        this.label = name;
        this.port = port;
        this.ip = ip;
        this.securePath = securePath;
        this.title = securePath && securePath != '' ? securePath : 'Could not create secure url.';
        let id_str = this.label + '_' + port;
        id_str = id_str.replace(/\s+|-/g, '_'); // replace spaces with an underscore
        this.html_id = id_str.replace(/_+/g, '_'); // remove any duplicated underscores
    }
}
;


/***/ }),

/***/ "./lib/widget.js":
/*!***********************!*\
  !*** ./lib/widget.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RStudioWorkbenchWidget": () => (/* binding */ RStudioWorkbenchWidget)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./lib/constants.js");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./handler */ "./lib/handler.js");
/* harmony import */ var _proxiedServersComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./proxiedServersComponent */ "./lib/proxiedServersComponent.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/*
 * widget.tsx
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */
// This file shares variables with './workbench_jupyterlab/constants.py'






function UseSignalComponent(props) {
    return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.UseSignal, { signal: props.signal, initialArgs: props.servers }, (_, servers) => react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_proxiedServersComponent__WEBPACK_IMPORTED_MODULE_3__.ProxiedServersComponent, { servers: servers })));
}
class RStudioWorkbenchWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor() {
        super();
        this.servers = new Map();
        this._signal = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._serverString = '';
        this._sessionUrl = '';
        this.addClass('jp-RStudioWorkbenchWidget');
    }
    getSessionUrl() {
        (0,_handler__WEBPACK_IMPORTED_MODULE_4__.requestAPI)(_constants__WEBPACK_IMPORTED_MODULE_5__.kUrlEndpoint).then((response) => {
            try {
                this._sessionUrl = response.baseSessionUrl;
            }
            catch (error) {
                console.log(`Received invalid response on GET /workbench-jupyterlab/url. \n${error}`);
            }
        }, (error) => {
            console.log(`Error on GET /workbench-jupyterlab/url. \n${error}`);
        });
    }
    requestServers() {
        (0,_handler__WEBPACK_IMPORTED_MODULE_4__.requestAPI)(_constants__WEBPACK_IMPORTED_MODULE_5__.kServerEndpoint).then((response) => {
            if (JSON.stringify(response.servers) != this._serverString) {
                this._serverString = JSON.stringify(response.servers);
                this.servers.clear();
                try {
                    response.servers.forEach((server) => {
                        this.servers.set(server.pid, [new _proxiedServersComponent__WEBPACK_IMPORTED_MODULE_3__.Server(server.pid, server.label, server.port, server.ip, `${this._sessionUrl}p/${server.secure_port}/`)]);
                    });
                    this._signal.emit(this.getServers());
                }
                catch (error) {
                    console.log(`Received invalid response on GET /workbench-jupyterlab/servers. \n${response}`);
                    return;
                }
            }
        }, (error) => {
            console.log(`Error on GET /workbench-jupyterlab/servers. \n${error}`);
        });
    }
    async onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.requestServers();
    }
    async onBeforeShow(msg) {
        super.onBeforeShow(msg);
        this.getSessionUrl();
        this.requestServers();
        this._timerID = setInterval(() => this.requestServers(), 3000);
    }
    onAfterHide(msg) {
        super.onAfterHide(msg);
        clearInterval(this._timerID);
    }
    getServers() {
        let serverArray = [];
        this.servers.forEach((value, key) => {
            serverArray = serverArray.concat(value);
        });
        return serverArray;
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(UseSignalComponent, { signal: this._signal, servers: this.getServers() }));
    }
}


/***/ })

}]);
//# sourceMappingURL=lib_index_js.67179098403118486ca2.js.map