"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tlsCertificate);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tlsCertificate);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpc(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tlsCertificate);
    }
}
exports.VirtualGatewayListener = VirtualGatewayListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualGatewayListener", version: "1.93.0" };
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, tlsCertificate) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.tlsCertificate = tlsCertificate;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        var _b;
        const tlsConfig = (_b = this.tlsCertificate) === null || _b === void 0 ? void 0 : _b.bind(scope);
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck ? renderHealthCheck(this.healthCheck, this.protocol, this.port) : undefined,
                tls: tlsConfig ? renderTls(tlsConfig) : undefined,
            },
        };
    }
}
/**
 * Renders the TLS config for a listener
 */
function renderTls(tlsCertificateConfig) {
    return {
        certificate: tlsCertificateConfig.tlsCertificate,
        mode: tlsCertificateConfig.tlsMode.toString(),
    };
}
function renderHealthCheck(hc, listenerProtocol, listenerPort) {
    if (hc.protocol === shared_interfaces_1.Protocol.TCP) {
        throw new Error('TCP health checks are not permitted for gateway listeners');
    }
    if (hc.protocol === shared_interfaces_1.Protocol.GRPC && hc.path) {
        throw new Error('The path property cannot be set with Protocol.GRPC');
    }
    const protocol = hc.protocol ? hc.protocol : listenerProtocol;
    const healthCheck = {
        healthyThreshold: hc.healthyThreshold || 2,
        intervalMillis: (hc.interval || cdk.Duration.seconds(5)).toMilliseconds(),
        path: hc.path || ((protocol === shared_interfaces_1.Protocol.HTTP || protocol === shared_interfaces_1.Protocol.HTTP2) ? '/' : undefined),
        port: hc.port || listenerPort,
        protocol: hc.protocol || listenerProtocol,
        timeoutMillis: (hc.timeout || cdk.Duration.seconds(2)).toMilliseconds(),
        unhealthyThreshold: hc.unhealthyThreshold || 2,
    };
    utils_1.validateHealthChecks(healthCheck);
    return healthCheck;
}
//# sourceMappingURL=data:application/json;base64,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