"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Provides the Service Discovery method a VirtualNode uses.
 *
 * @experimental
 */
class ServiceDiscovery {
    /**
     * (experimental) Returns DNS based service discovery.
     *
     * @experimental
     */
    static dns(hostname) {
        return new DnsServiceDiscovery(hostname);
    }
    /**
     * (experimental) Returns Cloud Map based service discovery.
     *
     * @experimental
     */
    static cloudMap(options) {
        return new CloudMapServiceDiscovery(options);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "@aws-cdk/aws-appmesh.ServiceDiscovery", version: "1.93.0" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname) {
        super();
        this.hostname = hostname;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(options) {
        super();
        this.service = options.service;
        this.instanceAttributes = options.instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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