import * as cdk from '@aws-cdk/core';
import { CfnRoute } from './appmesh.generated';
import { HttpTimeout, GrpcTimeout, TcpTimeout } from './shared-interfaces';
import { IVirtualNode } from './virtual-node';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Properties for the Weighted Targets in the route.
 *
 * @experimental
 */
export interface WeightedTarget {
    /**
     * (experimental) The VirtualNode the route points to.
     *
     * @experimental
     */
    readonly virtualNode: IVirtualNode;
    /**
     * (experimental) The weight for the target.
     *
     * @default 1
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) The criterion for determining a request match for this GatewayRoute.
 *
 * @experimental
 */
export interface HttpRouteMatch {
    /**
     * (experimental) Specifies the path to match requests with.
     *
     * This parameter must always start with /, which by itself matches all requests to the virtual service name.
     * You can also match for path-based routing of requests. For example, if your virtual service name is my-service.local
     * and you want the route to match requests to my-service.local/metrics, your prefix should be /metrics.
     *
     * @experimental
     */
    readonly prefixPath: string;
}
/**
 * (experimental) The criterion for determining a request match for this GatewayRoute.
 *
 * @experimental
 */
export interface GrpcRouteMatch {
    /**
     * (experimental) The fully qualified domain name for the service to match from the request.
     *
     * @experimental
     */
    readonly serviceName: string;
}
/**
 * (experimental) Properties specific for HTTP Based Routes.
 *
 * @experimental
 */
export interface HttpRouteSpecOptions {
    /**
     * (experimental) The criterion for determining a request match for this Route.
     *
     * @default - matches on '/'
     * @experimental
     */
    readonly match?: HttpRouteMatch;
    /**
     * (experimental) List of targets that traffic is routed to when a request matches the route.
     *
     * @experimental
     */
    readonly weightedTargets: WeightedTarget[];
    /**
     * (experimental) An object that represents a http timeout.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: HttpTimeout;
    /**
     * (experimental) The retry policy.
     *
     * @default - no retry policy
     * @experimental
     */
    readonly retryPolicy?: HttpRetryPolicy;
}
/**
 * (experimental) HTTP retry policy.
 *
 * @experimental
 */
export interface HttpRetryPolicy {
    /**
     * (experimental) Specify HTTP events on which to retry.
     *
     * You must specify at least one value
     * for at least one types of retry events.
     *
     * @default - no retries for http events
     * @experimental
     */
    readonly httpRetryEvents?: HttpRetryEvent[];
    /**
     * (experimental) The maximum number of retry attempts.
     *
     * @experimental
     */
    readonly retryAttempts: number;
    /**
     * (experimental) The timeout for each retry attempt.
     *
     * @experimental
     */
    readonly retryTimeout: cdk.Duration;
    /**
     * (experimental) TCP events on which to retry.
     *
     * The event occurs before any processing of a
     * request has started and is encountered when the upstream is temporarily or
     * permanently unavailable. You must specify at least one value for at least
     * one types of retry events.
     *
     * @default - no retries for tcp events
     * @experimental
     */
    readonly tcpRetryEvents?: TcpRetryEvent[];
}
/**
 * (experimental) HTTP events on which to retry.
 *
 * @experimental
 */
export declare enum HttpRetryEvent {
    /**
     * (experimental) HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511.
     *
     * @experimental
     */
    SERVER_ERROR = "server-error",
    /**
     * (experimental) HTTP status codes 502, 503, and 504.
     *
     * @experimental
     */
    GATEWAY_ERROR = "gateway-error",
    /**
     * (experimental) HTTP status code 409.
     *
     * @experimental
     */
    CLIENT_ERROR = "client-error",
    /**
     * (experimental) Retry on refused stream.
     *
     * @experimental
     */
    STREAM_ERROR = "stream-error"
}
/**
 * TCP events on which you may retry
 */
export declare enum TcpRetryEvent {
    /**
     * (experimental) TCP events on which you may retry.
     *
     * @experimental
     */
    CONNECTION_ERROR = "connection-error"
}
/**
 * (experimental) Properties specific for a TCP Based Routes.
 *
 * @experimental
 */
export interface TcpRouteSpecOptions {
    /**
     * (experimental) List of targets that traffic is routed to when a request matches the route.
     *
     * @experimental
     */
    readonly weightedTargets: WeightedTarget[];
    /**
     * (experimental) An object that represents a tcp timeout.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: TcpTimeout;
}
/**
 * (experimental) Properties specific for a GRPC Based Routes.
 *
 * @experimental
 */
export interface GrpcRouteSpecOptions {
    /**
     * (experimental) The criterion for determining a request match for this Route.
     *
     * @experimental
     */
    readonly match: GrpcRouteMatch;
    /**
     * (experimental) An object that represents a grpc timeout.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: GrpcTimeout;
    /**
     * (experimental) List of targets that traffic is routed to when a request matches the route.
     *
     * @experimental
     */
    readonly weightedTargets: WeightedTarget[];
    /**
     * (experimental) The retry policy.
     *
     * @default - no retry policy
     * @experimental
     */
    readonly retryPolicy?: GrpcRetryPolicy;
}
/**
 * (experimental) gRPC retry policy.
 *
 * @experimental
 */
export interface GrpcRetryPolicy extends HttpRetryPolicy {
    /**
     * (experimental) gRPC events on which to retry.
     *
     * You must specify at least one value
     * for at least one types of retry events.
     *
     * @default - no retries for gRPC events
     * @experimental
     */
    readonly grpcRetryEvents?: GrpcRetryEvent[];
}
/**
 * (experimental) gRPC events.
 *
 * @experimental
 */
export declare enum GrpcRetryEvent {
    /**
     * (experimental) Request was cancelled.
     *
     * @see https://grpc.github.io/grpc/core/md_doc_statuscodes.html
     * @experimental
     */
    CANCELLED = "cancelled",
    /**
     * (experimental) The deadline was exceeded.
     *
     * @see https://grpc.github.io/grpc/core/md_doc_statuscodes.html
     * @experimental
     */
    DEADLINE_EXCEEDED = "deadline-exceeded",
    /**
     * (experimental) Internal error.
     *
     * @see https://grpc.github.io/grpc/core/md_doc_statuscodes.html
     * @experimental
     */
    INTERNAL_ERROR = "internal",
    /**
     * (experimental) A resource was exhausted.
     *
     * @see https://grpc.github.io/grpc/core/md_doc_statuscodes.html
     * @experimental
     */
    RESOURCE_EXHAUSTED = "resource-exhausted",
    /**
     * (experimental) The service is unavailable.
     *
     * @see https://grpc.github.io/grpc/core/md_doc_statuscodes.html
     * @experimental
     */
    UNAVAILABLE = "unavailable"
}
/**
 * (experimental) All Properties for GatewayRoute Specs.
 *
 * @experimental
 */
export interface RouteSpecConfig {
    /**
     * (experimental) The spec for an http route.
     *
     * @default - no http spec
     * @experimental
     */
    readonly httpRouteSpec?: CfnRoute.HttpRouteProperty;
    /**
     * (experimental) The spec for an http2 route.
     *
     * @default - no http2 spec
     * @experimental
     */
    readonly http2RouteSpec?: CfnRoute.HttpRouteProperty;
    /**
     * (experimental) The spec for a grpc route.
     *
     * @default - no grpc spec
     * @experimental
     */
    readonly grpcRouteSpec?: CfnRoute.GrpcRouteProperty;
    /**
     * (experimental) The spec for a tcp route.
     *
     * @default - no tcp spec
     * @experimental
     */
    readonly tcpRouteSpec?: CfnRoute.TcpRouteProperty;
}
/**
 * (experimental) Used to generate specs with different protocols for a RouteSpec.
 *
 * @experimental
 */
export declare abstract class RouteSpec {
    /**
     * (experimental) Creates an HTTP Based RouteSpec.
     *
     * @experimental
     */
    static http(options: HttpRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Creates an HTTP2 Based RouteSpec.
     *
     * @experimental
     */
    static http2(options: HttpRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Creates a TCP Based RouteSpec.
     *
     * @experimental
     */
    static tcp(options: TcpRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Creates a GRPC Based RouteSpec.
     *
     * @experimental
     */
    static grpc(options: GrpcRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Called when the GatewayRouteSpec type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @experimental
     */
    abstract bind(scope: Construct): RouteSpecConfig;
}
