"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.render = void 0;
const sfn = require("../../lib");
/**
 * Renders a state machine definition
 *
 * @param stack stack for the state machine
 * @param definition state machine definition
 */
function render(stack, definition) {
    return stack.resolve(new sfn.StateGraph(definition.startState, 'Test Graph').toGraphJson());
}
exports.render = render;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVuZGVyLXV0aWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyZW5kZXItdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSxpQ0FBaUM7QUFFakM7Ozs7O0dBS0c7QUFDSCxTQUFnQixNQUFNLENBQUMsS0FBZ0IsRUFBRSxVQUEwQjtJQUNqRSxPQUFPLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxVQUFVLEVBQUUsWUFBWSxDQUFDLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztBQUM5RixDQUFDO0FBRkQsd0JBRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnLi4vLi4vbGliJztcblxuLyoqXG4gKiBSZW5kZXJzIGEgc3RhdGUgbWFjaGluZSBkZWZpbml0aW9uXG4gKlxuICogQHBhcmFtIHN0YWNrIHN0YWNrIGZvciB0aGUgc3RhdGUgbWFjaGluZVxuICogQHBhcmFtIGRlZmluaXRpb24gc3RhdGUgbWFjaGluZSBkZWZpbml0aW9uXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiByZW5kZXIoc3RhY2s6IGNkay5TdGFjaywgZGVmaW5pdGlvbjogc2ZuLklDaGFpbmFibGUpIHtcbiAgcmV0dXJuIHN0YWNrLnJlc29sdmUobmV3IHNmbi5TdGF0ZUdyYXBoKGRlZmluaXRpb24uc3RhcnRTdGF0ZSwgJ1Rlc3QgR3JhcGgnKS50b0dyYXBoSnNvbigpKTtcbn0iXX0=