from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

import attr

if TYPE_CHECKING:
    from ..models.example_row_response import ExampleRowResponse


T = TypeVar("T", bound="KanbanViewExampleResponseStack")


@attr.s(auto_attribs=True)
class KanbanViewExampleResponseStack:
    """
    Attributes:
        count (int): The total count of rows that are included in this group.
        results (List['ExampleRowResponse']): All the rows that belong in this group related with the provided `limit`
            and `offset`.
    """

    count: int
    results: List["ExampleRowResponse"]
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        count = self.count
        results = []
        for results_item_data in self.results:
            results_item = results_item_data.to_dict()

            results.append(results_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "count": count,
                "results": results,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.example_row_response import ExampleRowResponse

        d = src_dict.copy()
        count = d.pop("count")

        results = []
        _results = d.pop("results")
        for results_item_data in _results:
            results_item = ExampleRowResponse.from_dict(results_item_data)

            results.append(results_item)

        kanban_view_example_response_stack = cls(
            count=count,
            results=results,
        )

        kanban_view_example_response_stack.additional_properties = d
        return kanban_view_example_response_stack

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
