from enum import Enum


class FilterActionTypeEnum(str, Enum):
    ACCEPT_GROUP_INVITATION = "accept_group_invitation"
    BATCH_ASSIGN_ROLE = "batch_assign_role"
    CANCEL_USER_DELETION = "cancel_user_deletion"
    CHANGE_USER_PASSWORD = "change_user_password"
    CREATE_APPLICATION = "create_application"
    CREATE_DB_TOKEN = "create_db_token"
    CREATE_DECORATION = "create_decoration"
    CREATE_FIELD = "create_field"
    CREATE_GROUP = "create_group"
    CREATE_GROUP_INVITATION = "create_group_invitation"
    CREATE_ROW = "create_row"
    CREATE_ROWS = "create_rows"
    CREATE_ROW_COMMENT = "create_row_comment"
    CREATE_SNAPSHOT = "create_snapshot"
    CREATE_TABLE = "create_table"
    CREATE_TEAM = "create_team"
    CREATE_TEAM_SUBJECT = "create_team_subject"
    CREATE_USER = "create_user"
    CREATE_VIEW = "create_view"
    CREATE_VIEW_FILTER = "create_view_filter"
    CREATE_VIEW_SORT = "create_view_sort"
    CREATE_WEBHOOK = "create_webhook"
    DELETE_APPLICATION = "delete_application"
    DELETE_DB_TOKEN_KEY = "delete_db_token_key"
    DELETE_DECORATION = "delete_decoration"
    DELETE_FIELD = "delete_field"
    DELETE_GROUP = "delete_group"
    DELETE_GROUP_INVITATION = "delete_group_invitation"
    DELETE_ROW = "delete_row"
    DELETE_ROWS = "delete_rows"
    DELETE_SNAPSHOT = "delete_snapshot"
    DELETE_TABLE = "delete_table"
    DELETE_TEAM = "delete_team"
    DELETE_TEAM_SUBJECT = "delete_team_subject"
    DELETE_VIEW = "delete_view"
    DELETE_VIEW_FILTER = "delete_view_filter"
    DELETE_VIEW_SORT = "delete_view_sort"
    DELETE_WEBHOOK = "delete_webhook"
    DUPLICATE_APPLICATION = "duplicate_application"
    DUPLICATE_FIELD = "duplicate_field"
    DUPLICATE_TABLE = "duplicate_table"
    DUPLICATE_VIEW = "duplicate_view"
    EMPTY_TRASH = "empty_trash"
    EXPORT_TABLE = "export_table"
    IMPORT_DATABASE_FROM_AIRTABLE = "import_database_from_airtable"
    IMPORT_ROWS = "import_rows"
    INSTALL_TEMPLATE = "install_template"
    LEAVE_GROUP = "leave_group"
    MOVE_ROW = "move_row"
    ORDER_APPLICATIONS = "order_applications"
    ORDER_GROUPS = "order_groups"
    ORDER_TABLES = "order_tables"
    ORDER_VIEWS = "order_views"
    REJECT_GROUP_INVITATION = "reject_group_invitation"
    RESET_USER_PASSWORD = "reset_user_password"
    RESTORE_FROM_TRASH = "restore_from_trash"
    RESTORE_SNAPSHOT = "restore_snapshot"
    ROTATE_DB_TOKEN_KEY = "rotate_db_token_key"
    ROTATE_VIEW_SLUG = "rotate_view_slug"
    SCHEDULE_USER_DELETION = "schedule_user_deletion"
    SEND_RESET_USER_PASSWORD = "send_reset_user_password"
    SIGN_IN_USER = "sign_in_user"
    UPDATE_APPLICATION = "update_application"
    UPDATE_DB_TOKEN_NAME = "update_db_token_name"
    UPDATE_DB_TOKEN_PERMISSIONS = "update_db_token_permissions"
    UPDATE_DECORATION = "update_decoration"
    UPDATE_FIELD = "update_field"
    UPDATE_GROUP = "update_group"
    UPDATE_GROUP_INVITATION_PERMISSIONS = "update_group_invitation_permissions"
    UPDATE_ROW = "update_row"
    UPDATE_ROWS = "update_rows"
    UPDATE_TABLE = "update_table"
    UPDATE_TEAM = "update_team"
    UPDATE_USER = "update_user"
    UPDATE_VIEW = "update_view"
    UPDATE_VIEW_FIELD_OPTIONS = "update_view_field_options"
    UPDATE_VIEW_FILTER = "update_view_filter"
    UPDATE_VIEW_SORT = "update_view_sort"
    UPDATE_WEBHOOK = "update_webhook"

    def __str__(self) -> str:
        return str(self.value)
