# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from . import models


class KameleoLocalApiClientConfiguration(Configuration):
    """Configuration for KameleoLocalApiClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        if not base_url:
            base_url = 'http://localhost:5050'

        super(KameleoLocalApiClientConfiguration, self).__init__(base_url)

        self.add_user_agent('kameleo.local_api_client/{}'.format(VERSION))


class KameleoLocalApiClient(SDKClient):
    """You can use the following API endpoints to communicate with the local running Kameleo programmatically.

    :ivar config: Configuration for client.
    :vartype config: KameleoLocalApiClientConfiguration

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        self.config = KameleoLocalApiClientConfiguration(base_url)
        super(KameleoLocalApiClient, self).__init__(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def get_base_profile_search_parameters(
            self, device_type=None, os_family=None, browser_product=None, language=None, custom_headers=None, raw=False, **operation_config):
        """Get the possible values for base profile filtering. We can filter the
        available values. With this we can see for example that what languages
        of profiles do we have for Windows profiles with Chrome.

        :param device_type: Filter option for the Device Type. Possible values
         are 'desktop', 'mobile'. For example set it to mobile if you only want
         to see what os families we have for mobile profiles.
        :type device_type: str
        :param os_family: Filter option for os family. Possible values are
         'windows', 'macos', 'linux', 'android', 'ios'. For example set it to
         windows if you only want to see what languages we have for windows
         profiles.
        :type os_family: str
        :param browser_product: Filter option for browser product. Possible
         values are 'chrome', 'firefox', 'edge', 'safari'. For example set it
         to safari if you only want to see what os families we have for chrome
         profiles.
        :type browser_product: str
        :param language: Filter option for os language. Use ISO 639-1 language
         code format. For example set it to en-gb if you only want to see what
         browser products we have for English profiles.
        :type language: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: BaseProfileSearchParameters or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.BaseProfileSearchParameters
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.get_base_profile_search_parameters.metadata['url']

        # Construct parameters
        query_parameters = {}
        if device_type is not None:
            query_parameters['deviceType'] = self._serialize.query("device_type", device_type, 'str')
        if os_family is not None:
            query_parameters['osFamily'] = self._serialize.query("os_family", os_family, 'str')
        if browser_product is not None:
            query_parameters['browserProduct'] = self._serialize.query("browser_product", browser_product, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseProfileSearchParameters', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_base_profile_search_parameters.metadata = {'url': '/base-profile-search-parameters'}

    def search_base_profiles(
            self, device_type=None, os_family=None, browser_product=None, language=None, custom_headers=None, raw=False, **operation_config):
        """Filtering base profiles with some criteria. It will return X base
        profiles. It is not an idempotent method. This means if you are calling
        it twice after each other it may return a different set of base
        profiles.

        :param device_type: Filter option for the Device Type. Possible values
         are 'desktop', 'mobile'. For example set it to mobile if you only want
         to get mobile profiles.
        :type device_type: str
        :param os_family: Filter option for os family. Possible values are
         'windows', 'macos', 'linux', 'android', 'ios'. For example set it to
         windows if you only want to get Windows profiles.
        :type os_family: str
        :param browser_product: Filter option for browser product. Possible
         values are 'chrome', 'firefox', 'edge', 'safari'. For example set it
         to safari if you only want to get profiles with Safari browser.
        :type browser_product: str
        :param language: Filter option for os language. Use ISO 639-1 language
         code format. For example set it to en-gb if you only want to get
         English profiles.
        :type language: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~kameleo.local_api_client.models.BaseProfilePreview] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.search_base_profiles.metadata['url']

        # Construct parameters
        query_parameters = {}
        if device_type is not None:
            query_parameters['deviceType'] = self._serialize.query("device_type", device_type, 'str')
        if os_family is not None:
            query_parameters['osFamily'] = self._serialize.query("os_family", os_family, 'str')
        if browser_product is not None:
            query_parameters['browserProduct'] = self._serialize.query("browser_product", browser_product, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[BaseProfilePreview]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    search_base_profiles.metadata = {'url': '/base-profiles'}

    def list_cookies(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Gets the list of the cookies of the profile.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~kameleo.local_api_client.models.BrowserCookie] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.list_cookies.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[BrowserCookie]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_cookies.metadata = {'url': '/profiles/{guid}/cookies'}

    def add_cookies(
            self, guid, body=None, custom_headers=None, raw=False, **operation_config):
        """Adds a list of cookies to the profile. If cookies are already present
        for a domain, they will be overwritten.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param body:
        :type body: list[~kameleo.local_api_client.models.CookieRequest]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~kameleo.local_api_client.models.BrowserCookie] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.add_cookies.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[CookieRequest]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[BrowserCookie]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    add_cookies.metadata = {'url': '/profiles/{guid}/cookies'}

    def delete_cookies(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Deletes the cookies of the profile.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.delete_cookies.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_cookies.metadata = {'url': '/profiles/{guid}/cookies'}

    def healthcheck(
            self, custom_headers=None, raw=False, **operation_config):
        """Health check request to test if Kameleo has been started and accepting
        connections.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.healthcheck.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    healthcheck.metadata = {'url': '/general/healthcheck'}

    def get_user_info(
            self, custom_headers=None, raw=False, **operation_config):
        """Provides information about the user.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: UserInfoResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.UserInfoResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.get_user_info.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserInfoResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_user_info.metadata = {'url': '/general/user-info'}

    def terminate_application(
            self, custom_headers=None, raw=False, **operation_config):
        """Terminates the Kameleo session by deauthenticating and exiting the CLI.
        It is important to call it after operating with Kameleo, so other users
        of the team account won't be logged out.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.terminate_application.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    terminate_application.metadata = {'url': '/general/terminate'}

    def test_proxy(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Tests a provided proxy connection.

        :param body:
        :type body: ~kameleo.local_api_client.models.TestProxyRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TestProxyResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.TestProxyResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`TestProxyResponseException<kameleo.local_api_client.models.TestProxyResponseException>`
        """
        # Construct URL
        url = self.test_proxy.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TestProxyRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.TestProxyResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TestProxyResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    test_proxy.metadata = {'url': '/general/test-proxy'}

    def list_profiles(
            self, custom_headers=None, raw=False, **operation_config):
        """Gets a preview list about profiles that are currently in the system.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~kameleo.local_api_client.models.ProfilePreview] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.list_profiles.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ProfilePreview]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_profiles.metadata = {'url': '/profiles'}

    def create_profile(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new profile based on a selected BaseProfile and inputs.

        :param body:
        :type body: ~kameleo.local_api_client.models.CreateProfileRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProfileResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.ProfileResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.create_profile.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'CreateProfileRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_profile.metadata = {'url': '/profiles/new'}

    def update_profile(
            self, guid, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates profile settings.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param body:
        :type body: ~kameleo.local_api_client.models.UpdateProfileRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProfileResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.ProfileResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.update_profile.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UpdateProfileRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_profile.metadata = {'url': '/profiles/{guid}'}

    def read_profile(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Returns a profile from the system.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProfileResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.ProfileResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.read_profile.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    read_profile.metadata = {'url': '/profiles/{guid}'}

    def delete_profile(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Removes profile from the system. When you are launching and stopping a
        big number of profiles for example for scraping it is recommended to
        call this after you have stopped the profile. This will free up disk
        space.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.delete_profile.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_profile.metadata = {'url': '/profiles/{guid}'}

    def get_profile_status(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Returns the current status of the profile.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: StatusResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.StatusResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.get_profile_status.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('StatusResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_profile_status.metadata = {'url': '/profiles/{guid}/status'}

    def start_profile(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Starts a profile. The browser will be launched. In case of mobile
        profiles and external launcher types the external spoofing engine will
        be launched.
        If successful, the profile's lifetime state will be 'running'.
        Otherwise the profile's lifetime state will be 'terminated'. During the
        api call the lifetime state can be 'starting' for a temporarily.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: StatusResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.StatusResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.start_profile.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('StatusResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    start_profile.metadata = {'url': '/profiles/{guid}/start'}

    def start_profile_with_web_driver_settings(
            self, guid, body=None, custom_headers=None, raw=False, **operation_config):
        """Starts a profile, for desktop profiles additional WebDriver settings
        can be provided. The browser will be launched. In case of mobile
        profiles and external launcher types the external spoofing engine will
        be launched.
        If successful, the profile's lifetime state will be 'running'.
        Otherwise the profile's lifetime state will be 'terminated'. During the
        api call the lifetime state can be 'starting' for a temporarily.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param body:
        :type body: ~kameleo.local_api_client.models.WebDriverSettings
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: StatusResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.StatusResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.start_profile_with_web_driver_settings.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'WebDriverSettings')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('StatusResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    start_profile_with_web_driver_settings.metadata = {'url': '/profiles/{guid}/start'}

    def stop_profile(
            self, guid, custom_headers=None, raw=False, **operation_config):
        """Stops a profile. The browsers will be stopped. In case of mobile
        profiles and external launcher types the external spoofing engine will
        be stopped.
        If successful, the profile's lifetime state will be 'terminated'.
        Otherwise the profile's lifetime state will be 'running'. During the
        api call the lifetime state can be 'terminating' for a temporarily.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: StatusResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.StatusResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.stop_profile.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('StatusResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    stop_profile.metadata = {'url': '/profiles/{guid}/stop'}

    def save_profile(
            self, guid, body=None, custom_headers=None, raw=False, **operation_config):
        """Saves a profile to a file. It will create a .kameleo file to the
        required location. It will store all the profile settings, browsing
        data, cookies, history, bookmarks, installed extension / addons. Later
        it can be reloaded.

        :param guid: The unique identifier of the profile
        :type guid: str
        :param body:
        :type body: ~kameleo.local_api_client.models.SaveProfileRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProfileResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.ProfileResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.save_profile.metadata['url']
        path_format_arguments = {
            'guid': self._serialize.url("guid", guid, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SaveProfileRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    save_profile.metadata = {'url': '/profiles/{guid}/save'}

    def load_profile(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Loads a profile from a file. It will load the profile from a .kameleo
        file. It will load all the profile settings, browsing data, cookies,
        history, bookmarks, installed extension / addons.

        :param body:
        :type body: ~kameleo.local_api_client.models.LoadProfileRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProfileResponse or ClientRawResponse if raw=true
        :rtype: ~kameleo.local_api_client.models.ProfileResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ProblemResponseException<kameleo.local_api_client.models.ProblemResponseException>`
        """
        # Construct URL
        url = self.load_profile.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'LoadProfileRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ProblemResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    load_profile.metadata = {'url': '/profiles/load'}
