"""
    ICA Rest API

    This API can be used to interact with Illumina Connected Analytics.<br> <p> Authentication to the  API can be done in multiple ways:<br> <ul><li>For the entire API, except for the POST /tokens endpoint: API-key + JWT</li> <li>Only for the POST /tokens endpoint: API-key + Basic Authentication</li></ul> </p> <p> <b>API-key</b><br> API keys are managed within the Illumina portal where you can manage your profile after you have logged on. The API-key has to be provided in the X-API-Key header parameter when executing API calls to ICA. In the background, a JWT will be requested at the IDP of Illumina to create a session. A good practice is to not use the API-key for every API call, but to first generate a JWT and to use that for authentication in subsequent calls.<br> </p> <p> <b>JWT</b><br> To avoid using an API-key for each call, we recommend to request a JWT via the POST /tokens endpoint  using this API-key. The JWT will expire after a pre-configured period specified by a tenant administrator through the IAM console in the Illumina portal. The JWT is the preferred way for authentication.<br>A not yet expired, still valid JWT could be refreshed using the POST /tokens:refresh endpoint.<br> </p> <p> <b>Basic Authentication</b><br> Basic authentication is only supported by the POST /tokens endpoint for generating a JWT. Use \"Basic base64encoded(emailaddress:password)\" in the \"Authorization\" header parameter for this authentication method. In case having access to multiple tenants using the same email-address, also provide the \"tenant\" request parameter to indicate what tenant you would like to request a JWT for. </p>   # noqa: E501

    The version of the OpenAPI document: 3
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from libica.openapi.v2.api_client import ApiClient, Endpoint as _Endpoint
from libica.openapi.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from libica.openapi.v2.model.links import Links
from libica.openapi.v2.model.problem import Problem
from libica.openapi.v2.model.project_pipeline import ProjectPipeline
from libica.openapi.v2.model.project_pipeline_list import ProjectPipelineList


class ProjectPipelineApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_cwl_pipeline_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectPipeline,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/pipelines:createCwlPipeline',
                'operation_id': 'create_cwl_pipeline',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'code',
                    'description',
                    'workflow_cwl_file',
                    'parameters_xml_file',
                    'analysis_storage_id',
                    'tool_cwl_files',
                    'metadata_model_file',
                    'links',
                    'version_comment',
                    'categories',
                    'html_documentation',
                ],
                'required': [
                    'project_id',
                    'code',
                    'description',
                    'workflow_cwl_file',
                    'parameters_xml_file',
                    'analysis_storage_id',
                ],
                'nullable': [
                    'metadata_model_file',
                    'links',
                    'version_comment',
                    'categories',
                    'html_documentation',
                ],
                'enum': [
                ],
                'validation': [
                    'code',
                    'description',
                    'categories',
                ]
            },
            root_map={
                'validations': {
                    ('code',): {
                        'max_length': 255,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9 _-]*(\/[a-zA-Z0-9 _-]+)*+$',  # noqa: E501
                        },
                    },
                    ('description',): {
                        'max_length': 4000,
                        'min_length': 1,
                    },
                    ('categories',): {

                        'max_items': 4000,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'code':
                        (str,),
                    'description':
                        (str,),
                    'workflow_cwl_file':
                        (file_type,),
                    'parameters_xml_file':
                        (file_type,),
                    'analysis_storage_id':
                        (str,),
                    'tool_cwl_files':
                        ([file_type],),
                    'metadata_model_file':
                        (file_type, none_type,),
                    'links':
                        (Links,),
                    'version_comment':
                        (str, none_type,),
                    'categories':
                        ([str, none_type], none_type,),
                    'html_documentation':
                        (str, none_type,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'code': 'code',
                    'description': 'description',
                    'workflow_cwl_file': 'workflowCwlFile',
                    'parameters_xml_file': 'parametersXmlFile',
                    'analysis_storage_id': 'analysisStorageId',
                    'tool_cwl_files': 'toolCwlFiles',
                    'metadata_model_file': 'metadataModelFile',
                    'links': 'links',
                    'version_comment': 'versionComment',
                    'categories': 'categories',
                    'html_documentation': 'htmlDocumentation',
                },
                'location_map': {
                    'project_id': 'path',
                    'code': 'form',
                    'description': 'form',
                    'workflow_cwl_file': 'form',
                    'parameters_xml_file': 'form',
                    'analysis_storage_id': 'form',
                    'tool_cwl_files': 'form',
                    'metadata_model_file': 'form',
                    'links': 'form',
                    'version_comment': 'form',
                    'categories': 'form',
                    'html_documentation': 'form',
                },
                'collection_format_map': {
                    'tool_cwl_files': 'csv',
                    'categories': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_nextflow_pipeline_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectPipeline,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/pipelines:createNextflowPipeline',
                'operation_id': 'create_nextflow_pipeline',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'code',
                    'description',
                    'main_nextflow_file',
                    'parameters_xml_file',
                    'analysis_storage_id',
                    'other_nextflow_files',
                    'metadata_model_file',
                    'links',
                    'version_comment',
                    'categories',
                    'html_documentation',
                ],
                'required': [
                    'project_id',
                    'code',
                    'description',
                    'main_nextflow_file',
                    'parameters_xml_file',
                    'analysis_storage_id',
                ],
                'nullable': [
                    'metadata_model_file',
                    'links',
                    'version_comment',
                    'categories',
                    'html_documentation',
                ],
                'enum': [
                ],
                'validation': [
                    'code',
                    'description',
                    'categories',
                ]
            },
            root_map={
                'validations': {
                    ('code',): {
                        'max_length': 255,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9 _-]*(\/[a-zA-Z0-9 _-]+)*+$',  # noqa: E501
                        },
                    },
                    ('description',): {
                        'max_length': 4000,
                        'min_length': 1,
                    },
                    ('categories',): {

                        'max_items': 4000,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'code':
                        (str,),
                    'description':
                        (str,),
                    'main_nextflow_file':
                        (file_type,),
                    'parameters_xml_file':
                        (file_type,),
                    'analysis_storage_id':
                        (str,),
                    'other_nextflow_files':
                        ([file_type],),
                    'metadata_model_file':
                        (file_type, none_type,),
                    'links':
                        (Links,),
                    'version_comment':
                        (str, none_type,),
                    'categories':
                        ([str, none_type], none_type,),
                    'html_documentation':
                        (str, none_type,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'code': 'code',
                    'description': 'description',
                    'main_nextflow_file': 'mainNextflowFile',
                    'parameters_xml_file': 'parametersXmlFile',
                    'analysis_storage_id': 'analysisStorageId',
                    'other_nextflow_files': 'otherNextflowFiles',
                    'metadata_model_file': 'metadataModelFile',
                    'links': 'links',
                    'version_comment': 'versionComment',
                    'categories': 'categories',
                    'html_documentation': 'htmlDocumentation',
                },
                'location_map': {
                    'project_id': 'path',
                    'code': 'form',
                    'description': 'form',
                    'main_nextflow_file': 'form',
                    'parameters_xml_file': 'form',
                    'analysis_storage_id': 'form',
                    'other_nextflow_files': 'form',
                    'metadata_model_file': 'form',
                    'links': 'form',
                    'version_comment': 'form',
                    'categories': 'form',
                    'html_documentation': 'form',
                },
                'collection_format_map': {
                    'other_nextflow_files': 'csv',
                    'categories': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.get_project_pipelines_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectPipelineList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/pipelines',
                'operation_id': 'get_project_pipelines',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                },
                'location_map': {
                    'project_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.link_pipeline_to_project_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectPipeline,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/pipelines/{pipelineId}',
                'operation_id': 'link_pipeline_to_project',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'pipeline_id',
                ],
                'required': [
                    'project_id',
                    'pipeline_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'pipeline_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'pipeline_id': 'pipelineId',
                },
                'location_map': {
                    'project_id': 'path',
                    'pipeline_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.release_pipeline_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/pipelines/{pipelineId}:release',
                'operation_id': 'release_pipeline',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'pipeline_id',
                ],
                'required': [
                    'project_id',
                    'pipeline_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'pipeline_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'pipeline_id': 'pipelineId',
                },
                'location_map': {
                    'project_id': 'path',
                    'pipeline_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unlink_pipeline_from_project_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/pipelines/{pipelineId}',
                'operation_id': 'unlink_pipeline_from_project',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'pipeline_id',
                ],
                'required': [
                    'project_id',
                    'pipeline_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'pipeline_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'pipeline_id': 'pipelineId',
                },
                'location_map': {
                    'project_id': 'path',
                    'pipeline_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_cwl_pipeline(
        self,
        project_id,
        code,
        description,
        workflow_cwl_file,
        parameters_xml_file,
        analysis_storage_id,
        **kwargs
    ):
        """Create a CWL pipeline within a project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cwl_pipeline(project_id, code, description, workflow_cwl_file, parameters_xml_file, analysis_storage_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): The ID of the project
            code (str): The code of the CWL pipeline
            description (str): The description of the CWL pipeline
            workflow_cwl_file (file_type): The CWL workflow file.
            parameters_xml_file (file_type):
            analysis_storage_id (str): The id of the storage to use for the pipeline.

        Keyword Args:
            tool_cwl_files ([file_type]): [optional]
            metadata_model_file (file_type, none_type): The metadata model json file(contents can be retrieved from the controlplane).. [optional]
            links (Links): [optional]
            version_comment (str, none_type): [optional]
            categories ([str, none_type], none_type): [optional]
            html_documentation (str, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectPipeline
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['code'] = \
            code
        kwargs['description'] = \
            description
        kwargs['workflow_cwl_file'] = \
            workflow_cwl_file
        kwargs['parameters_xml_file'] = \
            parameters_xml_file
        kwargs['analysis_storage_id'] = \
            analysis_storage_id
        return self.create_cwl_pipeline_endpoint.call_with_http_info(**kwargs)

    def create_nextflow_pipeline(
        self,
        project_id,
        code,
        description,
        main_nextflow_file,
        parameters_xml_file,
        analysis_storage_id,
        **kwargs
    ):
        """Create a Nextflow pipeline within a project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_nextflow_pipeline(project_id, code, description, main_nextflow_file, parameters_xml_file, analysis_storage_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): The ID of the project
            code (str): The code of the pipeline
            description (str): The description of the pipeline
            main_nextflow_file (file_type): The main Nextflow file.
            parameters_xml_file (file_type):
            analysis_storage_id (str): The id of the storage to use for the pipeline.

        Keyword Args:
            other_nextflow_files ([file_type]): [optional]
            metadata_model_file (file_type, none_type): The metadata model json file(contents can be retrieved from the controlplane).. [optional]
            links (Links): [optional]
            version_comment (str, none_type): [optional]
            categories ([str, none_type], none_type): [optional]
            html_documentation (str, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectPipeline
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['code'] = \
            code
        kwargs['description'] = \
            description
        kwargs['main_nextflow_file'] = \
            main_nextflow_file
        kwargs['parameters_xml_file'] = \
            parameters_xml_file
        kwargs['analysis_storage_id'] = \
            analysis_storage_id
        return self.create_nextflow_pipeline_endpoint.call_with_http_info(**kwargs)

    def get_project_pipelines(
        self,
        project_id,
        **kwargs
    ):
        """Retrieve a list of project pipelines.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_pipelines(project_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): The ID of the project to retrieve pipelines for

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectPipelineList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        return self.get_project_pipelines_endpoint.call_with_http_info(**kwargs)

    def link_pipeline_to_project(
        self,
        project_id,
        pipeline_id,
        **kwargs
    ):
        """Link a pipeline to a project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.link_pipeline_to_project(project_id, pipeline_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): The ID of the project
            pipeline_id (str): The ID of the pipeline

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectPipeline
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['pipeline_id'] = \
            pipeline_id
        return self.link_pipeline_to_project_endpoint.call_with_http_info(**kwargs)

    def release_pipeline(
        self,
        project_id,
        pipeline_id,
        **kwargs
    ):
        """Release a pipeline.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.release_pipeline(project_id, pipeline_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): The ID of the project
            pipeline_id (str): The ID of the pipeline

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['pipeline_id'] = \
            pipeline_id
        return self.release_pipeline_endpoint.call_with_http_info(**kwargs)

    def unlink_pipeline_from_project(
        self,
        project_id,
        pipeline_id,
        **kwargs
    ):
        """Unlink a pipeline from a project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unlink_pipeline_from_project(project_id, pipeline_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): The ID of the project
            pipeline_id (str): The ID of the pipeline

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['pipeline_id'] = \
            pipeline_id
        return self.unlink_pipeline_from_project_endpoint.call_with_http_info(**kwargs)

