# coding: utf-8

"""
    Genomic Data Store Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from libica.openapi.libgds.configuration import Configuration


class CreateVolumeRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'volume_configuration_name': 'str',
        'root_key_prefix': 'str',
        'metadata': 'object',
        'life_cycle': 'VolumeLifeCycleSettings'
    }

    attribute_map = {
        'name': 'name',
        'volume_configuration_name': 'volumeConfigurationName',
        'root_key_prefix': 'rootKeyPrefix',
        'metadata': 'metadata',
        'life_cycle': 'lifeCycle'
    }

    def __init__(self, name=None, volume_configuration_name=None, root_key_prefix=None, metadata=None, life_cycle=None, local_vars_configuration=None):  # noqa: E501
        """CreateVolumeRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._volume_configuration_name = None
        self._root_key_prefix = None
        self._metadata = None
        self._life_cycle = None
        self.discriminator = None

        self.name = name
        if volume_configuration_name is not None:
            self.volume_configuration_name = volume_configuration_name
        if root_key_prefix is not None:
            self.root_key_prefix = root_key_prefix
        if metadata is not None:
            self.metadata = metadata
        if life_cycle is not None:
            self.life_cycle = life_cycle

    @property
    def name(self):
        """Gets the name of this CreateVolumeRequest.  # noqa: E501

        Name for the volume  # noqa: E501

        :return: The name of this CreateVolumeRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateVolumeRequest.

        Name for the volume  # noqa: E501

        :param name: The name of this CreateVolumeRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def volume_configuration_name(self):
        """Gets the volume_configuration_name of this CreateVolumeRequest.  # noqa: E501

        Unique name of the volume configuration to use  # noqa: E501

        :return: The volume_configuration_name of this CreateVolumeRequest.  # noqa: E501
        :rtype: str
        """
        return self._volume_configuration_name

    @volume_configuration_name.setter
    def volume_configuration_name(self, volume_configuration_name):
        """Sets the volume_configuration_name of this CreateVolumeRequest.

        Unique name of the volume configuration to use  # noqa: E501

        :param volume_configuration_name: The volume_configuration_name of this CreateVolumeRequest.  # noqa: E501
        :type: str
        """

        self._volume_configuration_name = volume_configuration_name

    @property
    def root_key_prefix(self):
        """Gets the root_key_prefix of this CreateVolumeRequest.  # noqa: E501

        The base bucket location for volumes associated with custom VolumeConfigurations. If not provided, the given volume Name is used.  If provided, it must start with the VolumeConfiguration's keyprefix and end with a /.  To create a volume representing the root of a bucket, use the value '/'.  # noqa: E501

        :return: The root_key_prefix of this CreateVolumeRequest.  # noqa: E501
        :rtype: str
        """
        return self._root_key_prefix

    @root_key_prefix.setter
    def root_key_prefix(self, root_key_prefix):
        """Sets the root_key_prefix of this CreateVolumeRequest.

        The base bucket location for volumes associated with custom VolumeConfigurations. If not provided, the given volume Name is used.  If provided, it must start with the VolumeConfiguration's keyprefix and end with a /.  To create a volume representing the root of a bucket, use the value '/'.  # noqa: E501

        :param root_key_prefix: The root_key_prefix of this CreateVolumeRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                root_key_prefix is not None and not re.search(r'^(\/)$|^([^\/].*[\/])$', root_key_prefix)):  # noqa: E501
            raise ValueError(r"Invalid value for `root_key_prefix`, must be a follow pattern or equal to `/^(\/)$|^([^\/].*[\/])$/`")  # noqa: E501

        self._root_key_prefix = root_key_prefix

    @property
    def metadata(self):
        """Gets the metadata of this CreateVolumeRequest.  # noqa: E501

        Metadata about this volume and its contents  # noqa: E501

        :return: The metadata of this CreateVolumeRequest.  # noqa: E501
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this CreateVolumeRequest.

        Metadata about this volume and its contents  # noqa: E501

        :param metadata: The metadata of this CreateVolumeRequest.  # noqa: E501
        :type: object
        """

        self._metadata = metadata

    @property
    def life_cycle(self):
        """Gets the life_cycle of this CreateVolumeRequest.  # noqa: E501


        :return: The life_cycle of this CreateVolumeRequest.  # noqa: E501
        :rtype: VolumeLifeCycleSettings
        """
        return self._life_cycle

    @life_cycle.setter
    def life_cycle(self, life_cycle):
        """Sets the life_cycle of this CreateVolumeRequest.


        :param life_cycle: The life_cycle of this CreateVolumeRequest.  # noqa: E501
        :type: VolumeLifeCycleSettings
        """

        self._life_cycle = life_cycle

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateVolumeRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateVolumeRequest):
            return True

        return self.to_dict() != other.to_dict()
