"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCargoManifestPath = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
function getCargoManifestPath(manifestPath) {
    // const manifestPathProp = props.manifestPath ?? 'Cargo.toml';
    const parsedManifestPath = path_1.parse(manifestPath);
    let manifestPathResult;
    if (parsedManifestPath.base && parsedManifestPath.ext && parsedManifestPath.base === 'Cargo.toml') {
        if (!fs_1.existsSync(manifestPath)) {
            throw new Error('Cargo.toml doesn\'t exist');
        }
        manifestPathResult = manifestPath;
    }
    else if (parsedManifestPath.base && parsedManifestPath.ext && parsedManifestPath.base != 'Cargo.toml') {
        throw new Error('manifestPath is specifying a file that is not Cargo.toml');
    }
    else if (!fs_1.existsSync(path_1.join(manifestPath, 'Cargo.toml'))) {
        throw new Error(`Cargo.toml file at ${manifestPath} doesn't exist`);
    }
    else {
        manifestPathResult = path_1.join(manifestPath, 'Cargo.toml');
    }
    return manifestPathResult;
}
exports.getCargoManifestPath = getCargoManifestPath;
//# sourceMappingURL=data:application/json;base64,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