# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['_boot',
 '_boot_fat',
 '_onewire',
 '_rp2',
 '_thread',
 '_uasyncio',
 '__init__',
 'central',
 'client',
 'core',
 'device',
 'l2cap',
 'peripheral',
 'server',
 'array',
 'binascii',
 'cmath',
 'dht',
 'ds18x20',
 'errno',
 'framebuf',
 'gc',
 'hashlib',
 'heapq',
 'json',
 'lsm6dsox',
 'machine',
 'math',
 'micropython',
 'neopixel',
 'network',
 'onewire',
 'os',
 'random',
 'rp2',
 'select',
 'socket',
 'struct',
 'sys',
 'time',
 'uarray',
 'event',
 'funcs',
 'lock',
 'stream',
 'task',
 'ubinascii',
 'ubluetooth',
 'ucollections',
 'ucryptolib',
 'uctypes',
 'uerrno',
 'uhashlib',
 'uheapq',
 'uio',
 'ujson',
 'umachine',
 'uos',
 'urandom',
 'ure',
 'uselect',
 'usocket',
 'ustruct',
 'usys',
 'utime',
 'uwebsocket',
 'uzlib',
 'websocket',
 'websocket_helper',
 'zlib']
install_requires = \
['micropython-stdlib-stubs>=0.9.0']

setup_kwargs = {
    'name': 'micropython-rp2-stubs',
    'version': '1.19.1.post11',
    'description': 'MicroPython stubs',
    'long_description': '# micropython-rp2-stubs\n\n\nThis is a stub-only package for MicroPython.\nIt is intended to be installed in a projects virtual environment to allow static type checkers and intellisense features to be used while writing Micropython code.\n\nThe version of this package is alligned the the version of the MicroPython firmware.\n - Major, Minor and Patch levels are alligned to the same version as the firmware.  \n - The post release level is used to publish new releases of the stubs.\n\nFor `Micropython 1.17` the stubs are published as `1.17.post1` ... `1.17.post2`  \nfor `Micropython 1.18` the stubs are published as `1.18.post1` ... `1.18.post2`  \n\nTo install the latest stubs:  \n`pip install -I  micropython-<port>-stubs` where port is the port of the MicroPython firmware.\n\nTo install the stubs for an older version, such as MicroPython 1.17:  \n`pip install micropython-stm32-stubs==1.17.*` which will install the last post release of the stubs for MicroPython 1.17.\n\n\nAs the creation of the stubs, and merging of the different types is still going though improvements, the stub packages are marked as Beta.\nTo upgrade stubs to the latest stubs for a specific version use `pip install micropython-stm32-stubs==1.17.* --upgrade`\n\nIf you have suggestions or find any issues with the stubs, please report them in the [MicroPython-stubs Discussions](https://github.com/Josverl/micropython-stubs/discussions)\n\nFor an overview of  Micropython Stubs please see: https://micropython-stubs.readthedocs.io/en/main/ \n * List of all stubs : https://micropython-stubs.readthedocs.io/en/main/firmware_grp.html\n\nIncluded stubs:\n* Merged stubs from `stubs/micropython-v1_19_1-rp2-merged`\n* Frozen stubs from `stubs/micropython-v1_19_1-frozen/rp2/GENERIC`\n* Core stubs from `stubs/cpython_core-pycopy`\n\n\norigin | Family | Port | Board | Version\n-------|--------|------|-------|--------\nFirmware | micropython | rp2 | Arduino Nano RP2040 Connect with RP2040 | v1.19.1 \nDocumentation | micropython | - | - | v1.19.1 \nCore | micropython | rp2 | - | v1.19.1 \n',
    'author': 'josverl',
    'author_email': 'josverl@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/josverl/micropython-stubs#micropython-stubs',
    'py_modules': modules,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
