# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['git_pusher']

package_data = \
{'': ['*']}

install_requires = \
['GitPython>=3.1.26,<4.0.0', 'pyfiglet>=0.8.post1,<0.9']

entry_points = \
{'console_scripts': ['git-pusher = git_pusher:main']}

setup_kwargs = {
    'name': 'git-pusher',
    'version': '0.1.0',
    'description': 'Push files in multiple git repos in one go',
    'long_description': '[![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![GPL3 License][license-shield]][license-url]\n[![LinkedIn][linkedin-shield]][linkedin-url]\n[![Ask Me Anything][ask-me-anything]][personal-page]\n\n<!-- PROJECT LOGO -->\n<br />\n<p align="center">\n  <a href="https://github.com/stiliajohny/python-git-pusher">\n    <img src=".assets/logo.png" alt="Main Logo" width="80" height="80">\n  </a>\n\n  <h3 align="center">python-git-pusher</h3>\n\n  <p align="center">\n    Push files to multiple repos in one go\n    <br />\n    <a href="./README.md"><strong>Explore the docs »</strong></a>\n    <br />\n    <br />\n    <a href="https://github.com/stiliajohny/python-git-pusher">View Demo</a>\n    ·\n    <a href="https://github.com/stiliajohny/python-git-pusher/issues/new?labels=i%3A+bug&template=1-bug-report.md">Report Bug</a>\n    ·\n    <a href="https://github.com/stiliajohny/python-git-pusher/issues/new?labels=i%3A+enhancement&template=2-feature-request.md">Request Feature</a>\n  </p>\n</p>\n\n<!-- TABLE OF CONTENTS -->\n\n## Table of Contents\n\n- [Table of Contents](#table-of-contents)\n- [About The Project](#about-the-project)\n  - [Built With](#built-with)\n- [Getting Started](#getting-started)\n  - [Prerequisites](#prerequisites)\n  - [Installation](#installation)\n- [Usage](#usage)\n- [Roadmap](#roadmap)\n- [Contributing](#contributing)\n- [License](#license)\n- [Contact](#contact)\n- [Acknowledgements](#acknowledgements)\n\n<!-- ABOUT THE PROJECT -->\n\n## About The Project\n\n[![python-git-pusher Screen Shot][product-screenshot]](./.assets/screenshot.png)\n\n<!--\nThere are many great README templates available on GitHub, however, I didn\'t find one that really suit my needs so I created this enhanced one. I want to create a README template so amazing that it\'ll be the last one you ever need.\n\nHere\'s why:\n\n- Your time should be focused on creating something amazing. A project that solves a problem and helps others\n- You shouldn\'t be doing the same tasks over and over like creating a README from scratch\n- You should element DRY principles to the rest of your life :smile:\n\nOf course, no one template will serve all projects since your needs may be different. So I\'ll be adding more in the near future. You may also suggest changes by forking this repo and creating a pull request or opening an issue.\n\nA list of commonly used resources that I find helpful are listed in the acknowledgements.\n-->\n\n### Built With\n\n<!--\nThis section should list any major frameworks that you built your project using. Leave any add-ons/plugins for the acknowledgements section. Here are a few examples.\n\n- [Bootstrap](https://getbootstrap.com)\n- [JQuery](https://jquery.com)\n- [Laravel](https://laravel.com)\n-->\n\n---\n\n<!-- GETTING STARTED -->\n\n## Getting Started\n\n<!--\nThis is an example of how you may give instructions on setting up your project locally.\nTo get a local copy up and running follow these simple example steps.\n-->\n\n### Prerequisites\n\n<!--\n\nThis is an example of how to list things you need to use the software and how to install them.\n\n- npm\n\n```sh\nnpm install npm@latest -g\n```\n-->\n\n### Installation\n\n<!--\n1. Get a free API Key at [https://example.com](https://example.com)\n2. Clone the repo\n\n```sh\ngit clone https://github.com/your_username_/Project-Name.git\n```\n\n3. Install NPM packages\n\n```sh\nnpm install\n```\n\n4. Enter your API in `config.js`\n\n```JS\nconst API_KEY = \'ENTER YOUR API\';\n```\n-->\n\n---\n\n<!-- USAGE EXAMPLES -->\n\n## Usage\n\n<!--\nUse this space to show useful examples of how a project can be used. Additional screenshots, code examples and demos work well in this space. You may also link to more resources.\n\n_For more examples, please refer to the [Documentation](https://example.com)_\n-->\n\n---\n\n<!-- ROADMAP -->\n\n## Roadmap\n\nSee the [open issues](https://github.com/stiliajohny/python-git-pusher/issues) for a list of proposed features (and known issues).\n\n---\n\n<!-- CONTRIBUTING -->\n\n## Contributing\n\nContributions are what make the open source community such an amazing place to be learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n\n---\n\n<!-- LICENSE -->\n\n## License\n\nDistributed under the GPLv3 License. See `LICENSE` for more information.\n\n<!-- CONTACT -->\n\n## Contact\n\nJohn Stilia - stilia.johny@gmail.com\n\n<!--\nProject Link: [https://github.com/your_username/repo_name](https://github.com/your_username/repo_name)\n-->\n\n---\n\n<!-- ACKNOWLEDGEMENTS -->\n\n## Acknowledgements\n\n- [GitHub Emoji Cheat Sheet](https://www.webpagefx.com/tools/emoji-cheat-sheet)\n- [Img Shields](https://shields.io)\n- [Choose an Open Source License](https://choosealicense.com)\n- [GitHub Pages](https://pages.github.com)\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n\n[contributors-shield]: https://img.shields.io/github/contributors/stiliajohny/python-git-pusher.svg?style=for-the-badge\n[contributors-url]: https://github.com/stiliajohny/python-git-pusher/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/stiliajohny/python-git-pusher.svg?style=for-the-badge\n[forks-url]: https://github.com/stiliajohny/python-git-pusher/network/members\n[stars-shield]: https://img.shields.io/github/stars/stiliajohny/python-git-pusher.svg?style=for-the-badge\n[stars-url]: https://github.com/stiliajohny/python-git-pusher/stargazers\n[issues-shield]: https://img.shields.io/github/issues/stiliajohny/python-git-pusher.svg?style=for-the-badge\n[issues-url]: https://github.com/stiliajohny/python-git-pusher/issues\n[license-shield]: https://img.shields.io/github/license/stiliajohny/python-git-pusher?style=for-the-badge\n[license-url]: https://github.com/stiliajohny/python-git-pusher/blob/master/LICENSE.txt\n[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[linkedin-url]: https://linkedin.com/in/johnstilia/\n[product-screenshot]: .assets/screenshot.png\n[ask-me-anything]: https://img.shields.io/badge/Ask%20me-anything-1abc9c.svg?style=for-the-badge\n[personal-page]: https://github.com/stiliajohny\n',
    'author': 'John Stilia',
    'author_email': 'stilia.johny@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://stiliajohny.github.io/python-git-pusher ',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
