# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.42.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class PackageRequired(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'seller_order_ref': 'str',
        'express_type': 'str',
        'currency': 'str',
        'mass_unit': 'str',
        'length_unit': 'str',
        'ship_from': 'AddressShip',
        'ship_to': 'AddressShip'
    }

    attribute_map = {
        'seller_order_ref': 'sellerOrderRef',
        'express_type': 'expressType',
        'currency': 'currency',
        'mass_unit': 'massUnit',
        'length_unit': 'lengthUnit',
        'ship_from': 'shipFrom',
        'ship_to': 'shipTo'
    }

    def __init__(self, seller_order_ref=None, express_type=None, currency='RMB', mass_unit='Kilogram', length_unit='Centimetre', ship_from=None, ship_to=None, local_vars_configuration=None):  # noqa: E501
        """PackageRequired - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._seller_order_ref = None
        self._express_type = None
        self._currency = None
        self._mass_unit = None
        self._length_unit = None
        self._ship_from = None
        self._ship_to = None
        self.discriminator = None

        self.seller_order_ref = seller_order_ref
        self.express_type = express_type
        self.currency = currency
        self.mass_unit = mass_unit
        self.length_unit = length_unit
        if ship_from is not None:
            self.ship_from = ship_from
        if ship_to is not None:
            self.ship_to = ship_to

    @property
    def seller_order_ref(self):
        """Gets the seller_order_ref of this PackageRequired.  # noqa: E501


        :return: The seller_order_ref of this PackageRequired.  # noqa: E501
        :rtype: str
        """
        return self._seller_order_ref

    @seller_order_ref.setter
    def seller_order_ref(self, seller_order_ref):
        """Sets the seller_order_ref of this PackageRequired.


        :param seller_order_ref: The seller_order_ref of this PackageRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and seller_order_ref is None:  # noqa: E501
            raise ValueError("Invalid value for `seller_order_ref`, must not be `None`")  # noqa: E501

        self._seller_order_ref = seller_order_ref

    @property
    def express_type(self):
        """Gets the express_type of this PackageRequired.  # noqa: E501


        :return: The express_type of this PackageRequired.  # noqa: E501
        :rtype: str
        """
        return self._express_type

    @express_type.setter
    def express_type(self, express_type):
        """Sets the express_type of this PackageRequired.


        :param express_type: The express_type of this PackageRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and express_type is None:  # noqa: E501
            raise ValueError("Invalid value for `express_type`, must not be `None`")  # noqa: E501

        self._express_type = express_type

    @property
    def currency(self):
        """Gets the currency of this PackageRequired.  # noqa: E501

        Price makes sense under an explicit currency, available options: RMB, CNY, USD, GBP  # noqa: E501

        :return: The currency of this PackageRequired.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this PackageRequired.

        Price makes sense under an explicit currency, available options: RMB, CNY, USD, GBP  # noqa: E501

        :param currency: The currency of this PackageRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def mass_unit(self):
        """Gets the mass_unit of this PackageRequired.  # noqa: E501


        :return: The mass_unit of this PackageRequired.  # noqa: E501
        :rtype: str
        """
        return self._mass_unit

    @mass_unit.setter
    def mass_unit(self, mass_unit):
        """Sets the mass_unit of this PackageRequired.


        :param mass_unit: The mass_unit of this PackageRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mass_unit is None:  # noqa: E501
            raise ValueError("Invalid value for `mass_unit`, must not be `None`")  # noqa: E501

        self._mass_unit = mass_unit

    @property
    def length_unit(self):
        """Gets the length_unit of this PackageRequired.  # noqa: E501


        :return: The length_unit of this PackageRequired.  # noqa: E501
        :rtype: str
        """
        return self._length_unit

    @length_unit.setter
    def length_unit(self, length_unit):
        """Sets the length_unit of this PackageRequired.


        :param length_unit: The length_unit of this PackageRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and length_unit is None:  # noqa: E501
            raise ValueError("Invalid value for `length_unit`, must not be `None`")  # noqa: E501

        self._length_unit = length_unit

    @property
    def ship_from(self):
        """Gets the ship_from of this PackageRequired.  # noqa: E501


        :return: The ship_from of this PackageRequired.  # noqa: E501
        :rtype: AddressShip
        """
        return self._ship_from

    @ship_from.setter
    def ship_from(self, ship_from):
        """Sets the ship_from of this PackageRequired.


        :param ship_from: The ship_from of this PackageRequired.  # noqa: E501
        :type: AddressShip
        """

        self._ship_from = ship_from

    @property
    def ship_to(self):
        """Gets the ship_to of this PackageRequired.  # noqa: E501


        :return: The ship_to of this PackageRequired.  # noqa: E501
        :rtype: AddressShip
        """
        return self._ship_to

    @ship_to.setter
    def ship_to(self, ship_to):
        """Sets the ship_to of this PackageRequired.


        :param ship_to: The ship_to of this PackageRequired.  # noqa: E501
        :type: AddressShip
        """

        self._ship_to = ship_to

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageRequired):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageRequired):
            return True

        return self.to_dict() != other.to_dict()
