#  Clipper

> **The Ultimate Cross-Platform Clipboard Manager for Developers**

[![PyPI version](https://badge.fury.io/py/clipper-dev.svg)](https://badge.fury.io/py/clipper-dev)
[![Python 3.10+](https://img.shields.io/badge/python-3.10+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Tests](https://img.shields.io/badge/tests-54%20passing-brightgreen.svg)](https://github.com/Rklearns/clipper-dev)
[![Platform](https://img.shields.io/badge/platform-macOS%20%7C%20Linux%20%7C%20Windows-lightgrey.svg)](https://github.com/Rklearns/clipper-dev)

<div align="center">


**Never lose your clipboard content again. Clipper is the developer's best friend for managing clipboard history with style.**

[**Documentation**](#-features) • [ **Quick Start**](#-quick-start) • [💡 **Examples**](#-examples) • [🤝 **Contributing**](#-contributing) • [📄 **License**](#-license)

</div>

---

## ✨ Why Clipper?

**Clipper** is not just another clipboard manager—it's a **developer productivity powerhouse** designed from the ground up for modern development workflows.

### 🎯 **Built for Developers, by Developers**

- **Lightning Fast**: Instant search across thousands of clipboard entries
- **Beautiful UI**: Rich terminal output that makes your terminal look professional
- **Smart Search**: Fuzzy search with intelligent ranking and highlighting
- **Cross-Platform**: Seamless experience across macOS, Linux, and Windows
- **Real-time Monitoring**: Automatic clipboard tracking with configurable intervals
- **Interactive TUI**: Beautiful terminal user interface for power users

### 🏆 **What Makes Clipper Special**

| Feature | Clipper | Others |
|---------|-----------|---------|
| **Speed** | ⚡ Instant | 🐌 Slow |
| **Search** | 🔍 Fuzzy + Smart | 📝 Basic |
| **UI** | 🎨 Rich + Beautiful | 📱 Plain |
| **Cross-Platform** | 🌍 All OS | 🖥️ Limited |
| **Developer Focus** | 👨‍💻 Built for devs | 👥 Generic |

---

## 🚀 Quick Start

### 📦 **Installation**

```bash
# Install from PyPI (recommended)
pip install clipper-dev

# Or install from source
git clone https://github.com/Rklearns/clipper-dev.git
cd clipper-dev
pip install -e .
```

### 🎯 **First Steps**

```bash
# Save current clipboard content
clipper add

# View your clipboard history
clipper list

# Search for specific content
clipper search "python code"

# Restore the last copied item
clipper pop
```

---

## 🎨 Features

### 🔥 **Core Functionality**

- **📋 Smart History**: Intelligent duplicate detection and content organization
- **🔍 Advanced Search**: Fuzzy search with configurable algorithms and scoring
- **⚡ Real-time Monitoring**: Automatic clipboard tracking with customizable intervals
- **🎯 Content Types**: Automatic detection and categorization of different content types
- **📊 Rich Statistics**: Comprehensive analytics and usage insights

### 🎭 **User Experience**

- **🎨 Rich Terminal Output**: Beautiful, colorful interface using Rich library
- **📱 Interactive TUI**: Full-featured terminal user interface
- **🔧 Configurable**: Extensive customization options
- **📱 Cross-Platform**: Consistent experience across all operating systems
- **⚡ Performance**: Optimized for speed and efficiency

### 🛠️ **Developer Tools**

- **📦 Easy Packaging**: Simple setup for distribution and deployment
- **🧪 Comprehensive Testing**: Full test coverage with pytest
- **📚 Documentation**: Extensive inline documentation and examples
- **🔧 Configuration**: Flexible configuration management
- **📊 Monitoring**: Built-in performance and usage monitoring

---

## 📖 Command Reference

### 🎯 **Essential Commands**

| Command | Description | Example |
|---------|-------------|---------|
| `add` | Save current clipboard content | `clipper add` |
| `list` | Display clipboard history | `clipper list` |
| `search <query>` | Fuzzy search history | `clipper search "api key"` |
| `pop` | Restore last item | `clipper pop` |
| `restore <index>` | Restore specific item | `clipper restore 3` |

### 🔍 **Advanced Commands**

| Command | Description | Example |
|---------|-------------|---------|
| `peek` | Show last copied item | `clipper peek` |
| `clear` | Clear entire history | `clipper clear` |
| `export <file>` | Export to JSON/CSV | `clipper export backup.json` |
| `import <file>` | Import from JSON/CSV | `clipper import backup.json` |
| `stats` | Show usage statistics | `clipper stats` |
| `info` | System information | `clipper info` |
| `tui` | Interactive terminal UI | `clipper tui` |
| `monitor` | Start clipboard monitoring | `clipper monitor` |

---

## 🎭 Interactive TUI

Experience Clipper in its full glory with our beautiful terminal user interface:

```bash
clipper tui
```

**Features:**
- 📋 **History Browser**: Navigate through your clipboard history
- 🔍 **Live Search**: Real-time search with instant results
- 📊 **Statistics Dashboard**: Visual representation of your usage
- ⚙️ **Settings Panel**: Configure Clipper to your preferences
- 🎨 **Rich Interface**: Beautiful colors and formatting

---

## ⚙️ Configuration

### 📁 **Configuration Files**

Clipper stores its configuration and history in:
- **History**: `~/.clipper.json`
- **Config**: `~/.clipper/config.toml`

### 🔧 **Customization Options**

```toml
# ~/.clipper/config.toml
[storage]
max_history = 200
storage_type = "json"  # or "sqlite" (future)

[display]
max_preview_length = 80
show_timestamps = true
color_scheme = "auto"

[clipboard]
auto_track = true
track_interval = 1.0
```

---

## 🧪 Development

### 🚀 **Setting Up Development Environment**

```bash
# Clone the repository
git clone https://github.com/Rklearns/clipper-dev.git
cd clipper-dev

# Create virtual environment
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate

# Install development dependencies
pip install -r requirements-dev.txt

# Install in development mode
pip install -e .
```

### 🧪 **Running Tests**

```bash
# Run all tests
pytest

# Run with coverage
pytest --cov=clipper --cov-report=html

# Run specific test file
pytest tests/test_clipboard.py
```

### 🔧 **Code Quality**

```bash
# Format code
black clipper/ tests/

# Lint code
flake8 clipper/ tests/

# Type checking
mypy clipper/

# Run all quality checks
make check
```

---

## 🤝 Contributing

We love contributions! Here's how you can help make Clipper even better:

### 🎯 **Ways to Contribute**

- 🐛 **Report Bugs**: Open an issue with detailed bug reports
- 💡 **Suggest Features**: Share your ideas for new features
- 📝 **Improve Documentation**: Help make our docs even better
- 🔧 **Fix Issues**: Pick up issues and submit pull requests
- 🌟 **Star the Project**: Show your support by starring

### 📋 **Contribution Guidelines**

1. **Fork** the repository
2. **Create** a feature branch (`git checkout -b feature/amazing-feature`)
3. **Commit** your changes (`git commit -m 'Add amazing feature'`)
4. **Push** to the branch (`git push origin feature/amazing-feature`)
5. **Open** a Pull Request

### 🏗️ **Development Setup**

```bash
# Install pre-commit hooks
pre-commit install

# Run pre-commit on all files
pre-commit run --all-files
```

---

## 📊 Performance

### ⚡ **Speed Benchmarks**

- **Search**: 1000+ items in <10ms
- **Add**: New items in <5ms
- **Startup**: Ready in <100ms
- **Memory**: Efficient memory usage

### 📈 **Scalability**

- **History Size**: Tested up to 10,000 items
- **Search Performance**: O(log n) complexity
- **Storage**: Optimized JSON with compression
- **Memory**: Intelligent caching and cleanup

---

## 🌟 Show Your Support

If Clipper has helped you become more productive, please consider:

- ⭐ **Starring** this repository
- 🚀 **Sharing** with your developer friends
- 💬 **Joining** our community discussions
- ☕ **Buying us a coffee** (if you're feeling generous)

---

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

**MIT License** means you can:
- ✅ Use Clipper commercially
- ✅ Modify and distribute
- ✅ Use privately
- ✅ Sublicense
- ❌ Hold authors liable
- ❌ Provide warranty

---

## 🙏 Acknowledgments

- **Rich**: For beautiful terminal output
- **Typer**: For excellent CLI framework
- **Textual**: For amazing TUI capabilities
- **pyperclip**: For cross-platform clipboard access
- **rapidfuzz**: For lightning-fast fuzzy search

---


<div align="center">

**Made with ❤️ by developers, for developers**



</div>
