# tp-p7

Un package python pour les TP de Physique de l'Université de Paris-Diderot, maintenant Université de Paris.

Ce package regroupe 2 outils disctints :

## linfitxy
linfitxy est une adaptation en python de l'outil linfitxy développé par Julien Browaÿes et Tristan Beau pour MATLAB : 
 [https://github.com/tjbtjbtjb/linfitxy]
linfitxy réalise un ajustement linéaire en prenant en compte les incertitude suivant l'axe de abscisses (x) et l'axe des ordonnées (y).

### usage

    import fitutils as fu
    res = fu.linfitxy(x, y, sx, sy)
    # x et y représentent les valeurs en x et y
    # sx et sy sont les incertitudes en x et en y

exemple : 

    import numpy as np
    import numpy.random as rd
    import matplotlib.pyplot as plt
    import fitutils as fu

    x = np.arange(5) + rd.normal(0, 0.1, 5)
    y = 2 * np.arange(5) + 12 + rd.normal(0, 0.1, 5)

    sx = np.ones(5) * 0.4
    sy = np.ones(5) * 1

    res = fu.linfitxy(x, y, sx, sy)
    plt.xlabel('x')
    plt.ylabel('y')
    plt.show()

### Oscillo
Oscillo est destiné à récupérer les données des oscilloscopes utilisés dans les salles de TP.
Il permet également de faire une copie d'écran.
Il est constitué d'une librairie permet d'utiliser facilement les fonctions de base par exemple dans un environnement comme Jupyter.
Il donne également accès à une application (en QT5) qui permet également facilement d'importer les données et de faire une copie d'écran.

Les oscilloscopes pris en charge pour le moment sont : 
- Tektronix
    - TDS
        - "1001B": (0x0699, 0x0362),
        - "1001C-EDU": (0x0699, 0x03aa),
        - "2004B": (0x0699, 0x0365),
        - "2024B": (0x0699, 0x036a), # Non testé
    - TBS
        - "1064": (0x0699, 0x03b3),
- Keyseight
    - DSO-X
        - "1102A": (0x2a8d, 0x1787),



- Auteur : Olivier Cardoso
- Email : Olivier.Cardoso@univ-paris-diderot.fr

   
