# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/00_aggregate.ipynb (unless otherwise specified).

__all__ = [
    "expand_aggregations_spec",
    "validate_aggregation_spec",
    "vallidate_all_aggregations",
]

# Cell
def expand_aggregations_spec(aggs: Dict) -> Dict:
    """Expands agg specs with multiple funcs each into a separate agg spec"""
    expanded_aggs = []
    for agg in aggs:
        # Get length for each that is iterable and not string
        lengths = [len(v) for v in agg.values() if is_expanded(v)]
        # None are lists
        if len(lengths) == 0:
            expanded_aggs.append(agg)
            continue
        # Mismatch length
        if len(set(lengths)) > 1:
            raise ValueError(f"Mismatch length of a param in {agg}")
        #
        max_length = max(lengths)
        listified = {
            k: v if is_expanded(v) else [v] * max_length for k, v in agg.items()
        }
        expanded_aggs += list(
            {k: v for k, v in zip(agg.keys(), vs)} for vs in zip(*listified.values())
        )

    return expanded_aggs


# Cell
def validate_aggregation_spec(agg: Dict, data_col: List[str]) -> List[str]:
    """Validates a single exapnded aggregation spec"""
    errors = []
    if "func" not in agg:
        errors.append(f"Missing key in agg {agg}")
    if hasattr(pd.Series, agg["func"]):
        errors.append(f"Unknown has no func {agg['func']} {agg}")
    if agg["column"] != GEO_INDEX_NAME and agg["column"] not in data_cols:
        errors.append(f"Column '{agg['column']}' in {agg} does not exist in the data")
    return errors


# Cell
def vallidate_all_aggregations(expanded_aggs: Dict, data: DataFrame):
    errors = []
    output_columns = set()
    for agg in expanded_aggs:
        errors += validate_aggregation_spec(agg, data.columns.value)
        if agg["output"] in output_columns:
            errors += f"Duplicate output column name found for {agg['output']}"
        else:
            output_columns.update(agg["update"])
    if errors:
        raise ValueError(f"Found the following issues\n:{'\n'.join(errors)}")
