"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunEcsFargateTask = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const run_ecs_task_base_1 = require("./run-ecs-task-base");
/**
 * Start a service on an ECS cluster
 *
 * @deprecated replaced by `EcsRunTask`
 */
class RunEcsFargateTask extends run_ecs_task_base_1.EcsRunTaskBase {
    constructor(props) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTask", "replaced by `EcsRunTask`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_RunEcsFargateTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (!props.taskDefinition.isFargateCompatible) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with Fargate');
        }
        if (!props.taskDefinition.defaultContainer) {
            throw new Error('A TaskDefinition must have at least one essential container');
        }
        super({
            ...props,
            parameters: {
                LaunchType: 'FARGATE',
            },
        });
        this.configureAwsVpcNetworking(props.cluster.vpc, props.assignPublicIp, props.subnets, props.securityGroup);
    }
}
exports.RunEcsFargateTask = RunEcsFargateTask;
_a = JSII_RTTI_SYMBOL_1;
RunEcsFargateTask[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTask", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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