"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallAwsService = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions task to call an AWS service API
 */
class CallAwsService extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallAwsServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (this.props.integrationPattern === sfn.IntegrationPattern.RUN_JOB) {
            throw new Error('The RUN_JOB integration pattern is not supported for CallAwsService');
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: props.iamResources,
                // The prefix and the action name are case insensitive
                // https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html
                actions: [(_b = props.iamAction) !== null && _b !== void 0 ? _b : `${props.service}:${props.action}`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        var _b;
        let service = this.props.service;
        if (!core_1.Token.isUnresolved(service)) {
            service = service.toLowerCase();
        }
        return {
            Resource: task_utils_1.integrationResourceArn('aws-sdk', `${service}:${this.props.action}`, this.props.integrationPattern),
            Parameters: (_b = sfn.FieldUtils.renderObject(this.props.parameters)) !== null && _b !== void 0 ? _b : {},
        };
    }
}
exports.CallAwsService = CallAwsService;
_a = JSII_RTTI_SYMBOL_1;
CallAwsService[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallAwsService", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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