import { App } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * The handler for this custom resource provider.
 *
 * @stability stable
 */
export interface ICustomResourceProviderHandler {
    /**
     * @stability stable
     */
    apply(scope: Construct, id: string, spec: any): Construct;
}
/**
 * @stability stable
 */
export interface CustomResourceProvider {
    /**
     * Kind of this custom resource.
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * API version of the custom resource.
     *
     * @default "v1"
     * @stability stable
     */
    readonly apiVersion: string;
    /**
     * The construct handler.
     *
     * @stability stable
     */
    readonly handler: ICustomResourceProviderHandler;
}
/**
 * @stability stable
 */
export interface OperatorProps {
    /**
     * A Kubernetes JSON manifest with a single resource that is matched against one of the providers within this operator.
     *
     * @default - first position command-line argument or "/dev/stdin"
     * @stability stable
     */
    readonly inputFile?: string;
    /**
     * Where to write the synthesized output.
     *
     * @default "/dev/stdout"
     * @stability stable
     */
    readonly outputFile?: string;
}
/**
 * A CDK8s app which allows implementing Kubernetes operators using CDK8s constructs.
 *
 * @stability stable
 */
export declare class Operator extends App {
    private readonly inputFile;
    private readonly outputFile?;
    private readonly providers;
    /**
     * @stability stable
     */
    constructor(props?: OperatorProps);
    /**
     * Adds a custom resource provider to this operator.
     *
     * @param provider The provider to add.
     * @stability stable
     */
    addProvider(provider: CustomResourceProvider): void;
    /**
     * Reads a Kubernetes manifest in JSON format from STDIN or the file specified as the first positional command-line argument.
     *
     * This manifest is expected to
     * include a single Kubernetes resource. Then, we match `apiVersion` and
     * `kind` to one of the registered providers and if we do, we invoke
     * `apply()`, passing it the `spec` of the input manifest and a chart as a
     * scope. The chart is then synthesized and the output manifest is written to
     * STDOUT.
     *
     * @stability stable
     */
    synth(): void;
    private findProvider;
}
