# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LayerVersionArgs', 'LayerVersion']

@pulumi.input_type
class LayerVersionArgs:
    def __init__(__self__, *,
                 content: pulumi.Input['LayerVersionContentArgs'],
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 layer_name: Optional[pulumi.Input[str]] = None,
                 license_info: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LayerVersion resource.
        """
        pulumi.set(__self__, "content", content)
        if compatible_runtimes is not None:
            pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if layer_name is not None:
            pulumi.set(__self__, "layer_name", layer_name)
        if license_info is not None:
            pulumi.set(__self__, "license_info", license_info)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input['LayerVersionContentArgs']:
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input['LayerVersionContentArgs']):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "compatible_runtimes")

    @compatible_runtimes.setter
    def compatible_runtimes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compatible_runtimes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "layer_name", value)

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "license_info")

    @license_info.setter
    def license_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_info", value)


warnings.warn("""LayerVersion is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class LayerVersion(pulumi.CustomResource):
    warnings.warn("""LayerVersion is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 content: Optional[pulumi.Input[pulumi.InputType['LayerVersionContentArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 layer_name: Optional[pulumi.Input[str]] = None,
                 license_info: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lambda::LayerVersion

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LayerVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lambda::LayerVersion

        :param str resource_name: The name of the resource.
        :param LayerVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LayerVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 content: Optional[pulumi.Input[pulumi.InputType['LayerVersionContentArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 layer_name: Optional[pulumi.Input[str]] = None,
                 license_info: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""LayerVersion is deprecated: LayerVersion is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LayerVersionArgs.__new__(LayerVersionArgs)

            __props__.__dict__["compatible_runtimes"] = compatible_runtimes
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            __props__.__dict__["layer_name"] = layer_name
            __props__.__dict__["license_info"] = license_info
        super(LayerVersion, __self__).__init__(
            'aws-native:lambda:LayerVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LayerVersion':
        """
        Get an existing LayerVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LayerVersionArgs.__new__(LayerVersionArgs)

        __props__.__dict__["compatible_runtimes"] = None
        __props__.__dict__["content"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["layer_name"] = None
        __props__.__dict__["license_info"] = None
        return LayerVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "compatible_runtimes")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output['outputs.LayerVersionContent']:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "layer_name")

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "license_info")

