# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateAuthorityArgs', 'CertificateAuthority']

@pulumi.input_type
class CertificateAuthorityArgs:
    def __init__(__self__, *,
                 key_algorithm: pulumi.Input[str],
                 signing_algorithm: pulumi.Input[str],
                 subject: pulumi.Input['CertificateAuthoritySubjectArgs'],
                 type: pulumi.Input[str],
                 csr_extensions: Optional[pulumi.Input['CertificateAuthorityCsrExtensionsArgs']] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 revocation_configuration: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityTagArgs']]]] = None):
        """
        The set of arguments for constructing a CertificateAuthority resource.
        :param pulumi.Input[str] key_algorithm: Public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
        :param pulumi.Input[str] signing_algorithm: Algorithm your CA uses to sign certificate requests.
        :param pulumi.Input['CertificateAuthoritySubjectArgs'] subject: Structure that contains X.500 distinguished name information for your CA.
        :param pulumi.Input[str] type: The type of the certificate authority.
        :param pulumi.Input['CertificateAuthorityCsrExtensionsArgs'] csr_extensions: Structure that contains CSR pass through extension information used by the CreateCertificateAuthority action.
        :param pulumi.Input[str] key_storage_security_standard: KeyStorageSecurityStadard defines a cryptographic key management compliance standard used for handling CA keys.
        :param pulumi.Input['CertificateAuthorityRevocationConfigurationArgs'] revocation_configuration: Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions.
        """
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "type", type)
        if csr_extensions is not None:
            pulumi.set(__self__, "csr_extensions", csr_extensions)
        if key_storage_security_standard is not None:
            pulumi.set(__self__, "key_storage_security_standard", key_storage_security_standard)
        if revocation_configuration is not None:
            pulumi.set(__self__, "revocation_configuration", revocation_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Input[str]:
        """
        Public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_algorithm", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Input[str]:
        """
        Algorithm your CA uses to sign certificate requests.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "signing_algorithm", value)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input['CertificateAuthoritySubjectArgs']:
        """
        Structure that contains X.500 distinguished name information for your CA.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input['CertificateAuthoritySubjectArgs']):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate authority.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="csrExtensions")
    def csr_extensions(self) -> Optional[pulumi.Input['CertificateAuthorityCsrExtensionsArgs']]:
        """
        Structure that contains CSR pass through extension information used by the CreateCertificateAuthority action.
        """
        return pulumi.get(self, "csr_extensions")

    @csr_extensions.setter
    def csr_extensions(self, value: Optional[pulumi.Input['CertificateAuthorityCsrExtensionsArgs']]):
        pulumi.set(self, "csr_extensions", value)

    @property
    @pulumi.getter(name="keyStorageSecurityStandard")
    def key_storage_security_standard(self) -> Optional[pulumi.Input[str]]:
        """
        KeyStorageSecurityStadard defines a cryptographic key management compliance standard used for handling CA keys.
        """
        return pulumi.get(self, "key_storage_security_standard")

    @key_storage_security_standard.setter
    def key_storage_security_standard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_storage_security_standard", value)

    @property
    @pulumi.getter(name="revocationConfiguration")
    def revocation_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']]:
        """
        Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions.
        """
        return pulumi.get(self, "revocation_configuration")

    @revocation_configuration.setter
    def revocation_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationArgs']]):
        pulumi.set(self, "revocation_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityTagArgs']]]]):
        pulumi.set(self, "tags", value)


class CertificateAuthority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr_extensions: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCsrExtensionsArgs']]] = None,
                 key_algorithm: Optional[pulumi.Input[str]] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 revocation_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[pulumi.InputType['CertificateAuthoritySubjectArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Private certificate authority.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCsrExtensionsArgs']] csr_extensions: Structure that contains CSR pass through extension information used by the CreateCertificateAuthority action.
        :param pulumi.Input[str] key_algorithm: Public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
        :param pulumi.Input[str] key_storage_security_standard: KeyStorageSecurityStadard defines a cryptographic key management compliance standard used for handling CA keys.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']] revocation_configuration: Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions.
        :param pulumi.Input[str] signing_algorithm: Algorithm your CA uses to sign certificate requests.
        :param pulumi.Input[pulumi.InputType['CertificateAuthoritySubjectArgs']] subject: Structure that contains X.500 distinguished name information for your CA.
        :param pulumi.Input[str] type: The type of the certificate authority.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateAuthorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Private certificate authority.

        :param str resource_name: The name of the resource.
        :param CertificateAuthorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateAuthorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr_extensions: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCsrExtensionsArgs']]] = None,
                 key_algorithm: Optional[pulumi.Input[str]] = None,
                 key_storage_security_standard: Optional[pulumi.Input[str]] = None,
                 revocation_configuration: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityRevocationConfigurationArgs']]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[pulumi.InputType['CertificateAuthoritySubjectArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateAuthorityArgs.__new__(CertificateAuthorityArgs)

            __props__.__dict__["csr_extensions"] = csr_extensions
            if key_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'key_algorithm'")
            __props__.__dict__["key_algorithm"] = key_algorithm
            __props__.__dict__["key_storage_security_standard"] = key_storage_security_standard
            __props__.__dict__["revocation_configuration"] = revocation_configuration
            if signing_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'signing_algorithm'")
            __props__.__dict__["signing_algorithm"] = signing_algorithm
            if subject is None and not opts.urn:
                raise TypeError("Missing required property 'subject'")
            __props__.__dict__["subject"] = subject
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate_signing_request"] = None
        super(CertificateAuthority, __self__).__init__(
            'aws-native:acmpca:CertificateAuthority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CertificateAuthority':
        """
        Get an existing CertificateAuthority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CertificateAuthorityArgs.__new__(CertificateAuthorityArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["certificate_signing_request"] = None
        __props__.__dict__["csr_extensions"] = None
        __props__.__dict__["key_algorithm"] = None
        __props__.__dict__["key_storage_security_standard"] = None
        __props__.__dict__["revocation_configuration"] = None
        __props__.__dict__["signing_algorithm"] = None
        __props__.__dict__["subject"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return CertificateAuthority(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the certificate authority.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> pulumi.Output[str]:
        """
        The base64 PEM-encoded certificate signing request (CSR) for your certificate authority certificate.
        """
        return pulumi.get(self, "certificate_signing_request")

    @property
    @pulumi.getter(name="csrExtensions")
    def csr_extensions(self) -> pulumi.Output[Optional['outputs.CertificateAuthorityCsrExtensions']]:
        """
        Structure that contains CSR pass through extension information used by the CreateCertificateAuthority action.
        """
        return pulumi.get(self, "csr_extensions")

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[str]:
        """
        Public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
        """
        return pulumi.get(self, "key_algorithm")

    @property
    @pulumi.getter(name="keyStorageSecurityStandard")
    def key_storage_security_standard(self) -> pulumi.Output[Optional[str]]:
        """
        KeyStorageSecurityStadard defines a cryptographic key management compliance standard used for handling CA keys.
        """
        return pulumi.get(self, "key_storage_security_standard")

    @property
    @pulumi.getter(name="revocationConfiguration")
    def revocation_configuration(self) -> pulumi.Output[Optional['outputs.CertificateAuthorityRevocationConfiguration']]:
        """
        Certificate revocation information used by the CreateCertificateAuthority and UpdateCertificateAuthority actions.
        """
        return pulumi.get(self, "revocation_configuration")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Output[str]:
        """
        Algorithm your CA uses to sign certificate requests.
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Output['outputs.CertificateAuthoritySubject']:
        """
        Structure that contains X.500 distinguished name information for your CA.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateAuthorityTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the certificate authority.
        """
        return pulumi.get(self, "type")

